/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.binary;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xmind.core.command.binary.ByteArrayEntry;
import org.xmind.core.command.binary.FileEntry;
import org.xmind.core.command.binary.IBinaryEntry;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.command.binary.INamedEntry;
import org.xmind.core.command.binary.NamedEntry;
import org.xmind.core.internal.command.BinaryUtil;
import org.xmind.core.internal.command.XMindCommandPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryStore
implements IBinaryStore {
    private Map<String, IBinaryEntry> entries = new HashMap<String, IBinaryEntry>();
    private List<String> entryNames = new ArrayList<String>();
    private File root;
    private byte[] buffer = new byte[4096];
    private int randomIndex = 1;

    public BinaryStore(File root) {
        this.root = root;
    }

    public BinaryStore(boolean useLocalFileCache) {
        if (useLocalFileCache) {
            File cacheDir = XMindCommandPlugin.getDefault().getBinaryCacheLocation();
            String rootName = String.format("%s-%s", String.valueOf(System.currentTimeMillis()), String.valueOf(new Random(System.currentTimeMillis()).nextInt()));
            this.root = new File(cacheDir, rootName);
        } else {
            this.root = null;
        }
    }

    public BinaryStore() {
        this(true);
    }

    @Override
    public synchronized Iterator<String> entryNames() {
        return this.entryNames.iterator();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.entries.size();
    }

    @Override
    public synchronized IBinaryEntry getEntry(String entryName) {
        return this.entries.get(entryName);
    }

    @Override
    public synchronized boolean hasEntry(String entryName) {
        return this.entries.containsKey(entryName);
    }

    @Override
    public synchronized void clear() {
        Object[] oldEntries = this.entries.values().toArray();
        this.entries.clear();
        this.entryNames.clear();
        int i = 0;
        while (i < oldEntries.length) {
            ((IBinaryEntry)oldEntries[i]).dispose();
            ++i;
        }
        if (this.root != null) {
            BinaryUtil.delete(this.root);
        }
    }

    @Override
    public synchronized boolean removeEntry(String entryName) {
        IBinaryEntry entry = this.entries.remove(entryName);
        if (entry != null) {
            this.entryNames.remove(entryName);
            entry.dispose();
        }
        return entry != null;
    }

    @Override
    public synchronized INamedEntry addEntry(IProgressMonitor monitor, InputStream source) throws IOException, InterruptedException {
        String entryName = this.generateRandomEntryName();
        IBinaryEntry realEntry = this.createEntry(monitor, entryName, source);
        NamedEntry entry = new NamedEntry(entryName, realEntry);
        this.addEntry(entryName, entry);
        return entry;
    }

    protected String generateRandomEntryName() {
        String entryName = String.valueOf(Long.toHexString(System.currentTimeMillis())) + "-" + this.randomIndex++ + "-" + Integer.toHexString(new Random().nextInt()) + ".tmp";
        return entryName;
    }

    @Override
    public synchronized IBinaryEntry addEntry(IProgressMonitor monitor, String entryName, InputStream source) throws IOException, InterruptedException {
        IBinaryEntry entry = this.createEntry(monitor, entryName, source);
        this.addEntry(entryName, entry);
        return entry;
    }

    @Override
    public synchronized void addEntry(String entryName, IBinaryEntry entry) {
        this.removeEntry(entryName);
        this.entries.put(entryName, entry);
        this.entryNames.add(entryName);
    }

    protected IBinaryEntry createEntry(IProgressMonitor monitor, String entryName, InputStream source) throws IOException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (this.root != null) {
            this.root.mkdirs();
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (this.root != null && this.root.isDirectory()) {
            if (entryName.endsWith("/")) {
                File file = new File(this.root, entryName.substring(0, entryName.length() - 1));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                file.mkdirs();
                return IBinaryEntry.NULL;
            }
            File file = new File(this.root, entryName);
            file.getParentFile().mkdirs();
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            try {
                FileOutputStream fout = new FileOutputStream(file);
                try {
                    int read;
                    while ((read = source.read(this.buffer)) > 0) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        ((OutputStream)fout).write(this.buffer, 0, read);
                    }
                }
                finally {
                    ((OutputStream)fout).close();
                }
            }
            finally {
                source.close();
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            return new FileEntry(file);
        }
        if (entryName.endsWith("/")) {
            return IBinaryEntry.NULL;
        }
        try {
            ByteArrayEntry byteArrayEntry;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            try {
                int read;
                while ((read = source.read(this.buffer)) > 0) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    out.write(this.buffer, 0, read);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                byteArrayEntry = new ByteArrayEntry(out.toByteArray());
            }
            catch (Throwable throwable) {
                out.close();
                throw throwable;
            }
            out.close();
            return byteArrayEntry;
        }
        finally {
            source.close();
        }
    }

    public String toString() {
        return this.entries.toString();
    }
}

