/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;
import org.xmind.gef.draw2d.ITransparentableFigure;
import org.xmind.gef.draw2d.PathFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Cancelable;
import org.xmind.ui.util.ICancelable;

public class UndoRedoTipsService
extends GraphicalViewerService
implements ICommandStackListener {
    public static final int DEFAULT_DURATION = 800;
    private static final int UPDATE_INTERVALS = 20;
    private static final double ALPHA_STEP = 30.0;
    private static final double ALPHA_STEP2 = 2.0;
    private static final double ALPHA_STEP3 = 8.0;
    private static final int SPEEDING_UP_ALPHA = 192;
    private ICommandStack commandStack;
    private IFigure layer;
    private IFigure frameLayer;
    private IFigure titleLayer;
    private Runnable mainTask;
    private Map<Command, ICancelable> subTasks;
    private int duration = 800;

    public UndoRedoTipsService(IGraphicalViewer viewer) {
        super(viewer);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = Math.max(1, duration);
    }

    public IFigure getLayer() {
        return this.layer;
    }

    public void setLayer(IFigure layer) {
        boolean hadLayers = this.hasLayers();
        this.layer = layer;
        boolean hasLayers = this.hasLayers();
        if (this.isActive()) {
            if (hadLayers && !hasLayers) {
                this.stopListenToCommandChange();
            } else if (!hadLayers && hasLayers) {
                this.startListenToCommandChange();
            }
        }
    }

    private IFigure getFrameLayer() {
        this.ensureLayers();
        return this.frameLayer;
    }

    private IFigure getTitleLayer() {
        this.ensureLayers();
        return this.titleLayer;
    }

    private void ensureLayers() {
        if (this.layer == null) {
            return;
        }
        if (this.frameLayer != null && this.titleLayer != null) {
            return;
        }
        if (this.frameLayer == null) {
            this.frameLayer = new FreeformLayer();
            if (this.titleLayer != null) {
                int index = this.layer.getChildren().indexOf(this.titleLayer);
                this.layer.add(this.frameLayer, index);
            } else {
                this.layer.add(this.frameLayer);
            }
        }
        if (this.titleLayer == null) {
            this.titleLayer = new FreeformLayer();
            this.layer.add(this.titleLayer);
        }
    }

    private boolean hasLayers() {
        return this.layer != null;
    }

    protected void activate() {
        this.commandStack = this.getViewer().getEditDomain().getCommandStack();
        if (this.hasLayers()) {
            this.startListenToCommandChange();
        }
    }

    protected void deactivate() {
        if (this.subTasks != null) {
            Object[] objectArray = this.subTasks.keySet().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.removeSubTask((Command)o);
                ++n2;
            }
            this.subTasks = null;
        }
        this.stopListenToCommandChange();
        this.commandStack = null;
        this.mainTask = null;
    }

    private void startListenToCommandChange() {
        if (this.commandStack != null) {
            this.commandStack.addCSListener((ICommandStackListener)this);
        }
    }

    private void stopListenToCommandChange() {
        if (this.commandStack != null) {
            this.commandStack.removeCSListener((ICommandStackListener)this);
        }
    }

    public void handleCommandStackEvent(CommandStackEvent event) {
        Command command = event.getCommand();
        if (command == null) {
            return;
        }
        int commandType = command.getType();
        if (event.getStatus() == 4 && commandType != 2) {
            this.showTipsFor(command, true, commandType != 1);
        } else if (event.getStatus() == 32 && commandType == 2) {
            this.showTipsFor(command, true, true);
        } else if (event.getStatus() == 2 && commandType != 1) {
            this.showTipsFor(command, false, commandType != 2);
        } else if (event.getStatus() == 16 && commandType == 1) {
            this.showTipsFor(command, false, true);
        }
    }

    private void showTipsFor(Command command, boolean undoOrRedo, boolean async) {
        if (!(command instanceof ISourceProvider)) {
            return;
        }
        Object[] elements = ((ISourceProvider)command).getSources().toArray();
        ArrayList<IGraphicalPart> parts = new ArrayList<IGraphicalPart>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IPart part = this.getViewer().findPart(element);
            if (part instanceof IGraphicalPart) {
                parts.add((IGraphicalPart)part);
            }
            ++n2;
        }
        if (parts.isEmpty()) {
            return;
        }
        this.showTipsFor(command, parts, this.getLabel(command, undoOrRedo), async);
    }

    private void showTipsFor(final Command command, List<IGraphicalPart> parts, String label, boolean async) {
        this.removeSubTask(command);
        final TipsUpdater task = new TipsUpdater(command, parts, label);
        if (async) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UndoRedoTipsService.this.getViewer().getCanvas().getLightweightSystem().getUpdateManager().runWithUpdate(new Runnable(){

                        @Override
                        public void run() {
                            Display.getCurrent().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    UndoRedoTipsService.this.addSubTask(command, (ICancelable)task);
                                }
                            });
                        }
                    });
                }
            });
        } else {
            this.addSubTask(command, (ICancelable)task);
        }
    }

    private void addSubTask(Command command, ICancelable task) {
        if (this.subTasks == null) {
            this.subTasks = new HashMap<Command, ICancelable>();
        }
        this.subTasks.put(command, task);
        this.ensureMainTaskStarted();
    }

    private void removeSubTask(Command command) {
        if (this.subTasks == null || this.subTasks.isEmpty()) {
            return;
        }
        ICancelable task = this.subTasks.remove(command);
        if (task != null) {
            task.cancel();
        }
    }

    private void ensureMainTaskStarted() {
        if (this.mainTask != null) {
            return;
        }
        this.mainTask = new MainTask(Display.getCurrent());
        this.mainTask.run();
    }

    private void mainTaskEnded() {
        this.mainTask = null;
        this.subTasks = null;
    }

    private String getLabel(Command command, boolean undoOrRedo) {
        String label = command.getLabel();
        if (label == null) {
            label = "";
        }
        if (undoOrRedo) {
            return NLS.bind((String)MindMapMessages.UndoRedoTipsService_Undo, (Object)label);
        }
        return NLS.bind((String)MindMapMessages.UndoRedoTipsService_Redo, (Object)label);
    }

    private class MainTask
    implements Runnable {
        private Display display;

        public MainTask(Display display) {
            this.display = display;
        }

        @Override
        public void run() {
            if (UndoRedoTipsService.this.subTasks == null || UndoRedoTipsService.this.subTasks.isEmpty()) {
                this.cancel();
                return;
            }
            if (Thread.currentThread() == this.display.getThread()) {
                Object[] objectArray = UndoRedoTipsService.this.subTasks.values().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((ICancelable)o).run();
                    ++n2;
                }
            } else {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Object[] objectArray = UndoRedoTipsService.this.subTasks.values().toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            ((ICancelable)o).run();
                            ++n2;
                        }
                    }
                });
            }
            if (UndoRedoTipsService.this.subTasks == null || UndoRedoTipsService.this.subTasks.isEmpty()) {
                this.cancel();
                return;
            }
            this.display.timerExec(20, (Runnable)this);
        }

        private void cancel() {
            UndoRedoTipsService.this.mainTaskEnded();
        }
    }

    private class Tip {
        private IGraphicalPart source;
        private String label;
        private PathFigure frame;
        private ITransparentableFigure title;

        public Tip(IGraphicalPart source, String label) {
            this.source = source;
            this.label = label;
        }

        public void setAlpha(int alpha) {
            if (this.frame == null) {
                this.frame = this.createFrameFigure();
            }
            if (this.title == null) {
                this.title = this.createTitleFigure();
            }
            if (this.frame != null) {
                this.frame.setAlpha(alpha);
            }
            if (this.title != null) {
                this.title.setMainAlpha(alpha);
                this.title.setSubAlpha(alpha);
            }
        }

        private PathFigure createFrameFigure() {
            if (UndoRedoTipsService.this.getFrameLayer() == null) {
                return null;
            }
            IFigure srcFigure = this.source.getFigure();
            if (srcFigure instanceof FreeformFigure) {
                return null;
            }
            Rectangle frameBounds = srcFigure.getBounds().getExpanded(4, 4);
            PathFigure figure = new PathFigure();
            UndoRedoTipsService.this.getFrameLayer().add((IFigure)figure);
            figure.setFill(false);
            figure.setOutline(true);
            figure.setBackgroundColor(this.getFrameColor());
            figure.setForegroundColor(this.getFrameColor());
            figure.setLineStyle(1);
            figure.setLineWidth(4);
            Path framePath = new Path((Device)Display.getCurrent());
            framePath.addRoundedRectangle(frameBounds, 4.0f);
            figure.setPath((org.eclipse.swt.graphics.Path)framePath);
            return figure;
        }

        private ITransparentableFigure createTitleFigure() {
            Point titleLoc;
            if (UndoRedoTipsService.this.getTitleLayer() == null) {
                return null;
            }
            RotatableWrapLabel figure = new RotatableWrapLabel(this.label);
            UndoRedoTipsService.this.getTitleLayer().add((IFigure)figure);
            figure.setFont(FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)(Util.isMac() ? 2 : 1)));
            figure.setForegroundColor(Display.getCurrent().getSystemColor(1));
            figure.setBackgroundColor(this.getFrameColor());
            Dimension size = figure.getPreferredSize();
            TitleBackground titleBg = new TitleBackground(size.height / 2, this.getFrameColor());
            figure.setBorder((Border)titleBg);
            IFigure srcFigure = this.source.getFigure();
            if (srcFigure instanceof FreeformFigure) {
                Rectangle extent = ((FreeformFigure)srcFigure).getFreeformExtent();
                titleLoc = new Point(extent.x + extent.width / 2, extent.y - 20);
            } else {
                Rectangle frameBounds = srcFigure.getBounds().getExpanded(4, 4);
                titleLoc = new Point(frameBounds.x + frameBounds.width / 2, frameBounds.y - 2);
            }
            size = figure.getPreferredSize();
            int x = titleLoc.x - size.width / 2;
            int y = titleLoc.y - size.height;
            Rectangle titleBounds = new Rectangle(x, y, size.width, size.height);
            figure.setBounds(titleBounds);
            return figure;
        }

        private Color getFrameColor() {
            return Display.getCurrent().getSystemColor(15);
        }

        public void dispose() {
            if (this.frame != null) {
                if (this.frame.getParent() != null) {
                    this.frame.getParent().remove((IFigure)this.frame);
                }
                org.eclipse.swt.graphics.Path path = this.frame.getPath();
                this.frame.setPath(null);
                if (path != null) {
                    path.dispose();
                }
                this.frame = null;
            }
            if (this.title != null) {
                if (this.title.getParent() != null) {
                    this.title.getParent().remove((IFigure)this.title);
                }
                this.title = null;
            }
        }
    }

    private class TipsUpdater
    extends Cancelable {
        private Command command;
        private List<Tip> tips;
        private double alpha = -1.0;
        private boolean showingOrHiding = true;
        private long shownTime = -1L;

        public TipsUpdater(Command command, List<IGraphicalPart> parts, String label) {
            this.command = command;
            this.tips = new ArrayList<Tip>(parts.size());
            for (IGraphicalPart part : parts) {
                this.tips.add(new Tip(part, label));
            }
        }

        public void cancel() {
            super.cancel();
            this.disposeTips();
            UndoRedoTipsService.this.removeSubTask(this.command);
        }

        private void disposeTips() {
            if (this.tips != null) {
                for (Tip tip : this.tips) {
                    tip.dispose();
                }
                this.tips = null;
            }
        }

        private double getRealAlphaStep(double step) {
            return step * 800.0 / (double)UndoRedoTipsService.this.getDuration();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void doJob() {
            if (MindMapUI.isAnimationEnabled()) {
                if (this.showingOrHiding) {
                    if (this.alpha < 0.0) {
                        this.alpha = 0.0;
                    } else {
                        this.alpha += this.getRealAlphaStep(30.0);
                        if (this.alpha > 255.0) {
                            this.alpha = 255.0;
                            this.showingOrHiding = false;
                        }
                    }
                } else if (this.alpha > 0.0) {
                    this.alpha = this.alpha > 192.0 ? (this.alpha -= this.getRealAlphaStep(2.0)) : (this.alpha -= this.getRealAlphaStep(8.0));
                }
            } else if (this.showingOrHiding) {
                this.alpha = 255.0;
                this.showingOrHiding = false;
                if (this.shownTime < 0L) {
                    this.shownTime = System.currentTimeMillis();
                }
            } else if (this.shownTime > 0L) {
                if (System.currentTimeMillis() <= this.shownTime + (long)UndoRedoTipsService.this.getDuration()) return;
                this.cancel();
            } else {
                this.cancel();
            }
            if (this.alpha <= 0.0) {
                if (this.showingOrHiding) return;
                this.cancel();
                return;
            } else {
                if (this.tips == null) return;
                for (Tip tip : this.tips) {
                    tip.setAlpha((int)this.alpha);
                }
            }
        }
    }

    private static class TitleBackground
    extends AbstractBackground {
        private int r;
        private int d;
        private Insets ins;
        private Color color;

        public TitleBackground(int r, Color color) {
            this.r = r;
            this.color = color;
            this.d = r * 2;
            this.ins = new Insets(0, r, 0, r);
        }

        public Insets getInsets(IFigure figure) {
            return this.ins;
        }

        public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle rect = TitleBackground.getPaintRectangle((IFigure)figure, (Insets)insets);
            Rectangle inner = rect.getShrinked(this.getInsets(figure));
            Path p = new Path((Device)Display.getCurrent());
            p.addArc((float)(inner.x - this.r), (float)inner.y, (float)this.d, (float)this.d, 90.0f, 180.0f);
            p.addRectangle(inner);
            p.addArc((float)(inner.right() - this.r), (float)inner.y, (float)this.d, (float)this.d, 270.0f, 180.0f);
            graphics.setFillRule(2);
            graphics.setBackgroundColor(this.color);
            graphics.fillPath((org.eclipse.swt.graphics.Path)p);
            p.dispose();
        }
    }
}

