/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IFileEntry;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.ModifyHyperlinkAction;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IHyperlinked;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;

public class HyperlinkInfoItemContributor
extends AbstractInfoItemContributor {
    @Override
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        String hyperlink = topic.getHyperlink();
        if (hyperlink == null) {
            return null;
        }
        IAction action = MindMapUI.getProtocolManager().createOpenHyperlinkAction(topicPart, hyperlink);
        if (action != null) {
            action.setId(MindMapActionFactory.OPEN_HYPERLINK.getId());
        }
        return action;
    }

    @Override
    public boolean isModified(ITopicPart topicPart, ITopic topic, IAction action) {
        if (!(action instanceof IHyperlinked)) {
            return true;
        }
        String hyperlink = topic.getHyperlink();
        String hyperlink2 = ((IHyperlinked)action).getHyperlink();
        return hyperlink == null && hyperlink2 != null || hyperlink != null && !hyperlink.equals(hyperlink2);
    }

    @Override
    public String getContent(ITopic topic) {
        return topic.getHyperlink();
    }

    @Override
    public String getSVGFilePath(ITopic topic, IAction action) {
        String hyperlink = topic.getHyperlink();
        if (hyperlink == null || action == null) {
            return null;
        }
        Object element = HyperlinkUtils.findElement((String)hyperlink, (IWorkbook)topic.getOwnedWorkbook());
        String filePath = "platform:/plugin/org.xmind.ui.mindmap/icons/";
        if (element != null && element instanceof ITopic) {
            String type = ((ITopic)element).getType();
            if ("root".equals(type)) {
                return String.valueOf(filePath) + "link_central_topic.svg";
            }
            if ("summary".equals(type)) {
                return String.valueOf(filePath) + "link_summary.svg";
            }
            if ("detached".equals(type)) {
                return String.valueOf(filePath) + "link_floating_topic.svg";
            }
            if ("callout".equals(type)) {
                return String.valueOf(filePath) + "link_callout.svg";
            }
            ITopic parent = ((ITopic)element).getParent();
            if (parent != null && parent.isRoot()) {
                return String.valueOf(filePath) + "link_main_topic.svg";
            }
            return String.valueOf(filePath) + "link_subtopic.svg";
        }
        if (this.isLinkToWeb(hyperlink)) {
            ImageDescriptor descriptor = action.getImageDescriptor();
            ImageDescriptor hyperlinkDescriptor = MindMapUI.getImages().get("hyperlink.png", true);
            if (descriptor != null && descriptor.equals(hyperlinkDescriptor)) {
                return String.valueOf(filePath) + "hyperlink.svg";
            }
        }
        return null;
    }

    @Override
    public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
        return this.isLinkToWeb(topic.getHyperlink()) && !this.isIconTipOnly(topicPart);
    }

    private boolean isLinkToWeb(String hyperlink) {
        return hyperlink != null && !hyperlink.startsWith("xap:") && !hyperlink.startsWith("xmind:") && !hyperlink.startsWith("file:");
    }

    @Override
    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("topicHyperlink");
        register.setNextSupport((ICoreEventSupport)topic.getOwnedWorkbook().getAdapter(ICoreEventSupport.class));
        register.register("topicAdd");
        register.register("topicRemove");
        register.register("titleText");
    }

    @Override
    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
        if ("topicAdd".equals(event.getType()) || "topicRemove".equals(event.getType()) || "titleText".equals(event.getType())) {
            String hyperlink = infoPart.getTopicPart().getTopic().getHyperlink();
            if (HyperlinkUtils.isInternalURL((String)hyperlink)) {
                Object target = HyperlinkUtils.findElement((String)hyperlink, (IWorkbook)infoPart.getTopicPart().getTopic().getOwnedWorkbook());
                if (target == event.getTarget()) {
                    infoPart.refresh();
                    infoPart.getTopicPart().refresh();
                }
                if ("titleText".equals(event.getType()) && target != null) {
                    infoPart.refresh();
                    infoPart.getTopicPart().refresh();
                }
            }
        } else {
            infoPart.refresh();
            infoPart.getTopicPart().refresh();
        }
    }

    @Override
    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        if ("topicAdd".equals(event.getType()) || "topicRemove".equals(event.getType()) || "titleText".equals(event.getType())) {
            Object target;
            String hyperlink = topicPart.getTopic().getHyperlink();
            if (HyperlinkUtils.isInternalURL((String)hyperlink) && (target = HyperlinkUtils.findElement((String)hyperlink, (IWorkbook)topicPart.getTopic().getOwnedWorkbook())) == event.getTarget()) {
                topicPart.refresh();
            }
        } else {
            topicPart.refresh();
        }
    }

    public void removeHyperlink(ITopic topic) {
        IGraphicalEditorPage page = this.getPage();
        if (page == null) {
            return;
        }
        Request request = new Request("modify_hyperlink").setParameter("text", null);
        request.setViewer((IViewer)page.getViewer());
        EditDomain domain = page.getEditDomain();
        if (domain != null) {
            domain.handleRequest(request);
        }
    }

    @Override
    public List<IAction> getPopupMenuActions(ITopicPart topicPart, final ITopic topic) {
        IGraphicalEditorPage page = this.getPage();
        if (page == null) {
            return Collections.emptyList();
        }
        ArrayList<IAction> actions = new ArrayList<IAction>();
        String url = topic.getHyperlink();
        if (!HyperlinkUtils.isAttachmentURL((String)url)) {
            ModifyHyperlinkAction modifyHyperlinkAction = new ModifyHyperlinkAction(page);
            modifyHyperlinkAction.setText(MindMapMessages.InfoItem_Modify_text);
            modifyHyperlinkAction.setImageDescriptor(null);
            actions.add((IAction)modifyHyperlinkAction);
        } else {
            Action saveAttchmentAsAction = new Action(MindMapMessages.InfoItem_SaveAttachment_text){

                public void run() {
                    HyperlinkInfoItemContributor.this.saveAttachmentAs(topic);
                }
            };
            actions.add((IAction)saveAttchmentAsAction);
        }
        Action deleteHyperlinkAction = new Action(MindMapMessages.InfoItem_Delete_text){

            public void run() {
                HyperlinkInfoItemContributor.this.removeHyperlink(topic);
            }
        };
        deleteHyperlinkAction.setId("org.xmind.ui.removeHyperlink");
        deleteHyperlinkAction.setImageDescriptor(null);
        actions.add((IAction)deleteHyperlinkAction);
        return actions;
    }

    private IGraphicalEditorPage getPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IGraphicalEditor editor = (IGraphicalEditor)window.getActivePage().getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getActivePageInstance();
    }

    private Object saveAttachmentAs(ITopic sourceTopic) {
        String targetPath;
        InputStream is;
        block16: {
            if (sourceTopic == null) {
                return null;
            }
            String url = sourceTopic.getHyperlink();
            if (!HyperlinkUtils.isAttachmentURL((String)url)) {
                return null;
            }
            String entryPath = HyperlinkUtils.toAttachmentPath((String)url);
            IFileEntry entry = sourceTopic.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
            if (entry == null) {
                return null;
            }
            is = entry.getInputStream();
            if (is == null) {
                return null;
            }
            try {
                Program p;
                String ext = FileUtils.getExtension((String)entryPath);
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*" + ext, "*.*"});
                String extension = ext;
                if (ext != null && (p = Program.findProgram((String)ext)) != null) {
                    extension = p.getName();
                }
                dialog.setFilterNames(new String[]{extension, NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName)});
                String name = sourceTopic.getTitleText();
                if (name != null && !name.endsWith(ext)) {
                    name = String.valueOf(name) + ext;
                }
                if (name != null) {
                    dialog.setFileName(name);
                }
                dialog.setOverwrite(true);
                targetPath = dialog.open();
                if (targetPath != null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                FileOutputStream os = new FileOutputStream(targetPath);
                FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
            }
        });
        try {
            is.close();
        }
        catch (IOException iOException) {}
        return null;
    }
}

