/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MindMapEditorInput;
import org.xmind.ui.internal.editor.PreLoadedWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.PrefUtils;
import org.xmind.ui.viewers.FileUtils;

public class MME {
    private static final String SUBDIR_WORKBOOKS = "workbooks/";

    public static IEditorInput createEditorInput(URI uri) {
        return new MindMapEditorInput(uri);
    }

    public static IEditorInput createEditorInput(IWorkbookRef workbookRef) {
        return new MindMapEditorInput(workbookRef);
    }

    public static IEditorInput createLoadedEditorInput(IWorkbook workbook) {
        return new MindMapEditorInput(PreLoadedWorkbookRef.createFromLoadedWorkbook(workbook, null));
    }

    public static IEditorInput createLoadedEditorInput(String name, IWorkbook workbook) {
        return new MindMapEditorInput(PreLoadedWorkbookRef.createFromLoadedWorkbook(workbook, name));
    }

    public static IEditorInput createNonExistingEditorInput() {
        return MindMapUI.getEditorInputFactory().createDefaultEditorInput();
    }

    @Deprecated
    public static IEditorInput createNamedEditorInput(String name) {
        return MindMapUI.getEditorInputFactory().createDefaultEditorInput();
    }

    @Deprecated
    public static IEditorInput createTemplatedEditorInput(InputStream templateStream) {
        return MindMapUI.getEditorInputFactory().createDefaultEditorInput();
    }

    @Deprecated
    public static IEditorInput createTemplatedEditorInput(String name, InputStream templateStream) {
        return MindMapUI.getEditorInputFactory().createDefaultEditorInput();
    }

    public static IEditorInput createFileEditorInput(String path) throws CoreException {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        return MME.createFileEditorInput(new File(path));
    }

    public static IEditorInput createFileEditorInput(File file) throws CoreException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        return new MindMapEditorInput(file.toURI());
    }

    public static IEditorInput createFileEditorInput(IFileStore fileStore) throws CoreException {
        if (fileStore == null) {
            throw new IllegalArgumentException("File store is null");
        }
        return new MindMapEditorInput(fileStore.toURI());
    }

    public static IEditorInput createFileEditorInput(IFile file) throws CoreException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        return new MindMapEditorInput(file.getLocationURI());
    }

    public static IEditorInput createEditorInputFromURI(String uri) {
        URI theURI;
        try {
            theURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return new MindMapEditorInput(theURI);
    }

    public static File getFile(Object input) {
        URI uri;
        File file = MindMapUIPlugin.getAdapter(input, File.class);
        if (file != null) {
            return file;
        }
        IFileStore fileStore = MindMapUIPlugin.getAdapter(input, IFileStore.class);
        if (fileStore != null && "file".equals((uri = fileStore.toURI()).getScheme())) {
            return new File(uri);
        }
        uri = MindMapUIPlugin.getAdapter(input, URI.class);
        if (uri != null && "file".equals(uri.getScheme())) {
            return new File(uri);
        }
        return null;
    }

    public static IFileStore getFileStore(Object input) {
        URI uri;
        File file;
        IFileStore fileStore = MindMapUIPlugin.getAdapter(input, IFileStore.class);
        if (fileStore == null && (file = MindMapUIPlugin.getAdapter(input, File.class)) != null) {
            try {
                fileStore = EFS.getStore((URI)file.toURI());
            }
            catch (CoreException coreException) {}
        }
        if (fileStore == null && (uri = MindMapUIPlugin.getAdapter(input, URI.class)) != null) {
            try {
                fileStore = EFS.getStore((URI)uri);
            }
            catch (CoreException coreException) {}
        }
        return fileStore;
    }

    public static URI getURIFromEditorInput(IEditorInput input) {
        URI uri = MindMapUIPlugin.getAdapter(input, URI.class);
        if (uri != null) {
            return uri;
        }
        IWorkbookRef workbookRef = MindMapUIPlugin.getAdapter(input, IWorkbookRef.class);
        if (workbookRef != null) {
            return workbookRef.getURI();
        }
        File file = (File)input.getAdapter(File.class);
        if (file != null) {
            return file.toURI();
        }
        return null;
    }

    public static void launch(IWorkbenchWindow window, String path, String fileName) {
        File file = new File(path);
        if (!file.exists() && Display.getCurrent() != null && !MessageDialog.openConfirm((Shell)window.getShell(), (String)DialogMessages.InfoFileNotExists_title, (String)NLS.bind((String)DialogMessages.InfoFileNotExists_message, (Object)path))) {
            return;
        }
        String extension = org.xmind.core.util.FileUtils.getExtension((String)path);
        if (".xmt".equalsIgnoreCase(extension) ? window != null && Display.getCurrent() != null && MME.openTemplate(window, path, fileName) : (".xmind".equalsIgnoreCase(extension) ? window != null && Display.getCurrent() != null && MME.openMindMap(window, path, fileName) : ".xmp".equalsIgnoreCase(extension) && MME.importMarkers(path))) {
            return;
        }
        FileUtils.launch((String)file.getAbsolutePath());
    }

    private static boolean openTemplate(IWorkbenchWindow window, String path, String fileName) {
        return MME.openMindMap(window, path, fileName);
    }

    private static boolean openMindMap(final IWorkbenchWindow window, final String path, String fileName) {
        String errMessage = NLS.bind((String)DialogMessages.FailedToLoadWorkbook_message, (Object)path);
        final boolean[] ret = new boolean[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(errMessage){

            public void run() throws Exception {
                window.getActivePage().openEditor(MindMapUI.getEditorInputFactory().createEditorInputForFile(new File(path)), "org.xmind.ui.MindMapEditor");
                ret[0] = true;
            }
        });
        return ret[0];
    }

    private static boolean importMarkers(String path) {
        try {
            MarkerImpExpUtils.importMarkerPackage(path);
            Display display = Display.getCurrent();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PrefUtils.openPrefDialog(null, (String)"org.xmind.ui.MarkersPrefPage");
                    }
                });
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static IStorage createTempStorage() {
        String tempName = String.valueOf(UUID.randomUUID().toString()) + ".xmind.temp";
        String tempDirPath = Core.getWorkspace().getTempDir(SUBDIR_WORKBOOKS + tempName);
        return new DirectoryStorage(new File(tempDirPath));
    }

    @Deprecated
    public static IEditorInput getEditorInputWithWorkbookAndEditors(IWorkbook workbook, IEditorReference[] editors) {
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ep = iEditorReferenceArray[n2];
            try {
                IEditorInput editorInput = ep.getEditorInput();
                if (editorInput != null && editorInput.getAdapter(IWorkbook.class) == workbook) {
                    return editorInput;
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return null;
    }
}

