/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.util.BufferedImages;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSink
extends AbstractImageSink<File> {
    private File destinationFile;
    private final boolean allowOverwrite;

    public FileImageSink(File destinationFile) {
        this(destinationFile, true);
    }

    public FileImageSink(File destinationFile, boolean allowOverwrite) {
        if (destinationFile == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = destinationFile;
        this.outputFormat = FileImageSink.getExtension(destinationFile);
        this.allowOverwrite = allowOverwrite;
    }

    public FileImageSink(String destinationFilePath) {
        this(destinationFilePath, true);
    }

    public FileImageSink(String destinationFilePath, boolean allowOverwrite) {
        if (destinationFilePath == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = new File(destinationFilePath);
        this.outputFormat = FileImageSink.getExtension(this.destinationFile);
        this.allowOverwrite = allowOverwrite;
    }

    private static boolean isMatchingFormat(String formatName, String fileExtension) {
        String[] suffixes;
        ImageWriter iw;
        if (formatName == null || fileExtension == null) {
            return false;
        }
        try {
            iw = ImageIO.getImageWritersByFormatName(formatName).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        String[] stringArray = suffixes = iw.getOriginatingProvider().getFileSuffixes();
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (fileExtension.equalsIgnoreCase(suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String getExtension(File f) {
        String fileName = f.getName();
        if (fileName.indexOf(46) != -1 && fileName.lastIndexOf(46) != fileName.length() - 1) {
            int lastIndex = fileName.lastIndexOf(46);
            return fileName.substring(lastIndex + 1);
        }
        return null;
    }

    @Override
    public String preferredOutputFormatName() {
        Iterator<ImageReader> rIter;
        String fileExtension = FileImageSink.getExtension(this.destinationFile);
        if (fileExtension != null && (rIter = ImageIO.getImageReadersBySuffix(fileExtension)).hasNext()) {
            try {
                return rIter.next().getFormatName();
            }
            catch (IOException iOException) {
                return ThumbnailParameter.ORIGINAL_FORMAT;
            }
        }
        return this.outputFormat;
    }

    @Override
    public void write(BufferedImage img) throws IOException {
        FileOutputStream fos;
        ImageOutputStream ios;
        Iterator<ImageReader> rIter;
        super.write(img);
        String fileExtension = FileImageSink.getExtension(this.destinationFile);
        String formatName = this.outputFormat;
        if (!(formatName == null || fileExtension != null && FileImageSink.isMatchingFormat(formatName, fileExtension))) {
            this.destinationFile = new File(String.valueOf(this.destinationFile.getAbsolutePath()) + "." + formatName);
        }
        if (!this.allowOverwrite && this.destinationFile.exists()) {
            throw new IllegalArgumentException("The destination file exists.");
        }
        if (formatName == null && fileExtension != null && (rIter = ImageIO.getImageReadersBySuffix(fileExtension)).hasNext()) {
            formatName = rIter.next().getFormatName();
        }
        if (formatName == null) {
            throw new UnsupportedFormatException(formatName, "Could not determine output format.");
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(formatName);
        if (!writers.hasNext()) {
            throw new UnsupportedFormatException(formatName, "No suitable ImageWriter found for " + formatName + ".");
        }
        ImageWriter writer = writers.next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        if (writeParam.canWriteCompressed() && this.param != null) {
            writeParam.setCompressionMode(2);
            if (this.param.getOutputFormatType() != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
                writeParam.setCompressionType(this.param.getOutputFormatType());
            } else {
                List<String> supportedFormats = ThumbnailatorUtils.getSupportedOutputFormatTypes(formatName);
                if (!supportedFormats.isEmpty()) {
                    writeParam.setCompressionType(supportedFormats.get(0));
                }
            }
            if (!Float.isNaN(this.param.getOutputQuality())) {
                writeParam.setCompressionQuality(this.param.getOutputQuality());
            }
        }
        if ((ios = ImageIO.createImageOutputStream(fos = new FileOutputStream(this.destinationFile))) == null || fos == null) {
            throw new IOException("Could not open output file.");
        }
        if (formatName.equalsIgnoreCase("jpg") || formatName.equalsIgnoreCase("jpeg") || formatName.equalsIgnoreCase("bmp")) {
            img = BufferedImages.copy(img, 1);
        }
        writer.setOutput(ios);
        writer.write(null, new IIOImage(img, null, null), writeParam);
        writer.dispose();
        ios.close();
        fos.close();
    }

    @Override
    public File getSink() {
        return this.destinationFile;
    }
}

