/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.ui.internal.iconfinder.IconfinderActivator;
import org.xmind.ui.internal.iconfinder.IconfinderCore;
import org.xmind.ui.internal.iconfinder.IconfinderModelPage;
import org.xmind.ui.io.DownloadJob;
import org.xmind.ui.io.IDownloadTarget;

public class IconfinderDownloadJob
extends DownloadJob {
    private long lastModificationTime;
    private IconfinderModelPage caller;

    public IconfinderDownloadJob(String jobName, String sourceURL, String targetPath, String pluginId) {
        super(jobName, sourceURL, targetPath, pluginId);
    }

    public IconfinderDownloadJob(String jobName, String sourceURL, String targetPath) {
        super(jobName, sourceURL, targetPath);
    }

    public IconfinderDownloadJob(String jobName, String sourceURL, IDownloadTarget target) {
        super(jobName, sourceURL, target, "org.xmind.ui.iconfinder");
    }

    public IconfinderDownloadJob(String jobName, String sourceURL, IDownloadTarget target, String pluginId) {
        super(jobName, sourceURL, target, pluginId);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = super.run(monitor);
        int severity = status.getSeverity();
        if (severity == 4) {
            IconfinderActivator.log(status.getException(), null);
            if (this.caller != null) {
                this.caller.connectError = true;
            }
            status = new Status(0, this.getPluginId(), status.getMessage(), status.getException());
        }
        if (this.caller != null) {
            this.caller.cancelSearch();
        }
        return status;
    }

    protected IStatus validateConnection(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            int respCode;
            block5: {
                respCode = ((HttpURLConnection)connection).getResponseCode();
                if (respCode < 200 || respCode >= 300) break block5;
                return null;
            }
            try {
                if (respCode >= 300 && respCode < 400) {
                    return Status.OK_STATUS;
                }
                return new Status(2, "org.xmind.ui.iconfinder", "Failed to download: " + respCode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.validateConnection(connection);
    }

    protected void setupConnection(URLConnection connection) {
        super.setupConnection(connection);
        if (this.lastModificationTime > 0L) {
            connection.setIfModifiedSince(this.lastModificationTime);
        }
        connection.setRequestProperty("X-Client-Version", System.getProperty("org.xmind.product.version", "XMind"));
    }

    public void setLastModificationTime(long lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public boolean belongsTo(Object family) {
        return IconfinderCore.getInstance().equals(family);
    }

    void setCaller(IconfinderModelPage modelPage) {
        this.caller = modelPage;
    }
}

