/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.org.freehep.graphicsio;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.IOException;
import org.xmind.org.freehep.graphicsio.PathConstructor;

public abstract class AbstractPathConstructor
implements PathConstructor {
    protected double currentX = 0.0;
    protected double currentY = 0.0;

    protected AbstractPathConstructor() {
    }

    public void flush() throws IOException {
        this.currentX = 0.0;
        this.currentY = 0.0;
    }

    public boolean addPath(Shape s) throws IOException {
        return this.addPath(s, null);
    }

    public boolean addPath(Shape s, AffineTransform transform) throws IOException {
        return AbstractPathConstructor.addPath(this, s, transform);
    }

    public static boolean addPath(PathConstructor out, Shape s, AffineTransform transform) throws IOException {
        PathIterator path = s.getPathIterator(transform);
        double[] coords = new double[6];
        double pathStartX = 0.0;
        double pathStartY = 0.0;
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    out.move(coords[0], coords[1]);
                    pathStartX = coords[0];
                    pathStartY = coords[1];
                    break;
                }
                case 1: {
                    out.line(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    out.quad(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    out.cubic(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    out.closePath(pathStartX, pathStartY);
                }
            }
            path.next();
        }
        out.flush();
        return path.getWindingRule() == 0;
    }

    public static boolean isEvenOdd(Shape s) {
        return s.getPathIterator(null).getWindingRule() == 0;
    }
}

