/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AdaptiveLabel
extends Composite {
    private String text = "";

    public AdaptiveLabel(Composite parent, int style) {
        super(parent, style);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                AdaptiveLabel.this.onPaint(event);
            }
        });
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            text = "";
        }
        if (text.equals(this.text)) {
            return;
        }
        this.text = text;
        this.redraw();
    }

    private void onPaint(Event event) {
        this.paintLabel(event.gc);
    }

    private void paintLabel(GC gc) {
        Rectangle r = this.getClientArea();
        gc.setForeground(this.getForeground());
        gc.setFont(this.getFont());
        Point textSize = gc.textExtent(this.text);
        Transform t = new Transform(gc.getDevice());
        try {
            float scaleX = Math.min(1.0f, (float)r.width / (float)textSize.x);
            float scaleY = Math.min(1.0f, (float)r.height / (float)textSize.y);
            float scale = Math.min(scaleX, scaleY);
            t.translate((float)r.x + (float)r.width / 2.0f, (float)r.y + (float)r.height / 2.0f);
            t.scale(scale, scale);
            gc.setTransform(t);
            gc.setTextAntialias(1);
            gc.drawText(this.text, -textSize.x / 2, -textSize.y / 2);
        }
        finally {
            t.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        if (wHint != -1 && hHint != -1) {
            size = new Point(wHint, hHint);
        } else if ("".equals(this.text)) {
            size = new Point(0, 0);
        } else {
            GC gc = new GC((Drawable)this);
            try {
                gc.setFont(this.getFont());
                size = gc.textExtent(this.text);
            }
            finally {
                gc.dispose();
            }
        }
        Rectangle trimmed = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trimmed.width, trimmed.height);
    }
}

