/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.gantt2.gefext.RangeModelProxy;

public class TimelineViewport
extends Viewport {
    private static final Rectangle RECT = new Rectangle();

    public TimelineViewport() {
        super(true);
        this.setHorizontalRangeModel(new RangeModelProxy());
        this.setLayoutManager((LayoutManager)new TimelineViewportLayout());
        this.setContentsTracksHeight(true);
    }

    protected void readjustScrollBars() {
        Rectangle r = this.getClientArea(RECT);
        this.getVerticalRangeModel().setAll(0, r.height, r.height);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.getHorizontalRangeModel()) {
            this.revalidate();
        }
    }

    private class TimelineViewportLayout
    extends ViewportLayout {
        private TimelineViewportLayout() {
        }

        public void layout(IFigure figure) {
            Viewport viewport = (Viewport)figure;
            IFigure contents = viewport.getContents();
            if (contents == null) {
                return;
            }
            RangeModel range = TimelineViewport.this.getHorizontalRangeModel();
            int min = range.getMinimum();
            int max = range.getMaximum();
            Rectangle r = viewport.getClientArea(RECT);
            r.x = min;
            r.y = 0;
            r.width = max - min;
            contents.setBounds(r);
        }
    }
}

