/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.part.IRootPart;
import org.xmind.ui.gantt2.gefext.GraphicalViewer2;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.DaysBackgroundFigure;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.HoursBackgroundFigure;
import org.xmind.ui.gantt2.viewer.PopupTaskInfoHelper;
import org.xmind.ui.gantt2.viewer.TaskBarPartFactory;
import org.xmind.ui.gantt2.viewer.TaskBarRootPart;
import org.xmind.ui.gantt2.viewer.TimeLineFigure;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.resources.ColorUtils;

public class TaskBarViewer
extends GraphicalViewer2
implements PropertyChangeListener,
FigureListener {
    public static final Object LAYER_DEPENDENCIES = "org.xmind.ui.gantt.layer.dependencies";
    public static final Object LAYER_TIMELINE = "org.xmind.ui.gantt.layer.timeline";
    public static final Object LAYER_BACKGROUND_SHADOW = "org.xmind.ui.gantt.layer.backgroundShadow";
    public static final Object LAYER_BACKGROUND_LINE = "org.xmind.ui.gantt.layer.backgroundLine";
    public static final String PARAM_SOURCE_ORIENTATION = "sourceOrientation";
    public static final String PARAM_TARGET_ORIENTATION = "targetOrientation";
    private static String TIME_LINE_COLOR = "#ff0000";
    private PopupTaskInfoHelper popupTaskInfoHelper = null;
    private TimeLineFigure nowTimeLine;
    private Timer timer;

    public TaskBarViewer() {
        this.setPartFactory(TaskBarPartFactory.DEFAULT);
        this.setRootPart((IRootPart)new TaskBarRootPart());
        this.getProperties().set("scrollSmooth", (Object)Boolean.TRUE);
    }

    protected Control internalCreateControl(Composite parent, int style) {
        FigureCanvas canvas = (FigureCanvas)super.internalCreateControl(parent, style);
        canvas.setHorizontalScrollBarVisibility(FigureCanvas.ALWAYS);
        canvas.setVerticalScrollBarVisibility(FigureCanvas.AUTOMATIC);
        this.createNowTimeLine();
        this.createPageContextMenu((Composite)canvas);
        FreeformLayeredPane pane = (FreeformLayeredPane)this.getViewport().getContents();
        pane.addFigureListener((FigureListener)this);
        this.getViewport().addFigureListener((FigureListener)this);
        return canvas;
    }

    private void createNowTimeLine() {
        this.nowTimeLine = new TimeLineFigure(ColorUtils.getColor((String)TIME_LINE_COLOR));
        Layer timelineLayer = this.getLayer(LAYER_TIMELINE);
        timelineLayer.add((IFigure)this.nowTimeLine);
        this.refreshTimerTask();
    }

    private void refreshTimerTask() {
        TimelineModel timelineModel = ((GanttEditDomain)this.getEditDomain()).getTimelineModel();
        if (this.timer != null) {
            this.timer.purge();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        TaskBarViewer.this.refreshTimeLine();
                    }
                });
            }
        }, (long)timelineModel.getPrecision() * 1000L);
    }

    private void refreshTimeLine() {
        Layer timelineLayer = this.getLayer(LAYER_TIMELINE);
        int end = this.calculateEnd();
        TimelineModel timelineModel = ((GanttEditDomain)this.getEditDomain()).getTimelineModel();
        long endTimeMillis = timelineModel.getOriginDate().getTimeInMillis() + timelineModel.getMillisFromPixels(end);
        if (endTimeMillis < System.currentTimeMillis()) {
            if (this.nowTimeLine.getParent() == timelineLayer) {
                timelineLayer.remove((IFigure)this.nowTimeLine);
            }
            if (this.timer != null) {
                this.timer.purge();
                this.timer = null;
            }
            return;
        }
        if (this.nowTimeLine.getParent() == null) {
            timelineLayer.add((IFigure)this.nowTimeLine);
        }
        int height = this.getHeight();
        int x = timelineModel.getPixelsFromMillis(System.currentTimeMillis() - timelineModel.getOriginDate().getTimeInMillis());
        this.nowTimeLine.setX(x);
        this.nowTimeLine.setHeight(height);
        this.nowTimeLine.setBounds(new Rectangle(this.nowTimeLine.getX(), 0, 1, height));
        this.nowTimeLine.revalidate();
    }

    private int getHeight() {
        int vpHeight = this.getViewport().getClientArea().height;
        int paneHeight = this.getViewport().getContents().getSize().height;
        return vpHeight > paneHeight ? vpHeight : paneHeight;
    }

    private void refreshBackgroundLayer() {
        Layer shadowLayer = this.getLayer(LAYER_BACKGROUND_SHADOW);
        shadowLayer.removeAll();
        int start = this.calculateStart();
        int end = this.calculateEnd();
        TimelineModel timelineModel = ((GanttEditDomain)this.getEditDomain()).getTimelineModel();
        Calendar startCalendar = GregorianCalendar.getInstance();
        startCalendar.setTimeInMillis(timelineModel.getOriginDate().getTimeInMillis() + timelineModel.getMillisFromPixels(start));
        Calendar endCalendar = GregorianCalendar.getInstance();
        endCalendar.setTimeInMillis(timelineModel.getOriginDate().getTimeInMillis() + timelineModel.getMillisFromPixels(end));
        double precision = timelineModel.getPrecision();
        if (precision > 5.0 && precision <= 144.0) {
            this.refreshHoursBackground(startCalendar, endCalendar, timelineModel);
        } else if (precision <= 3323.0) {
            this.refreshDaysBackground(startCalendar, endCalendar, timelineModel, true);
        } else if (precision <= 3456.0) {
            this.refreshDaysBackground(startCalendar, endCalendar, timelineModel, false);
        }
    }

    private int calculateStart() {
        Rectangle extent = ((FreeformLayer)this.getLayer(GEF.LAYER_CONTENTS)).getFreeformExtent();
        return extent.x >= 100 ? 0 : extent.x - 100;
    }

    private int calculateEnd() {
        Rectangle extent = ((FreeformLayer)this.getLayer(GEF.LAYER_CONTENTS)).getFreeformExtent();
        Rectangle clientArea = this.getViewport().getClientArea();
        if (extent.x + extent.width <= clientArea.width / 2) {
            return clientArea.width;
        }
        return extent.x + extent.width + clientArea.width / 2;
    }

    private void refreshHoursBackground(Calendar startCalendar, Calendar endCalendar, TimelineModel timelineModel) {
        HoursBackgroundFigure figure;
        GregorianCalendar currentEndCalendar;
        Layer shadowLayer = this.getLayer(LAYER_BACKGROUND_SHADOW);
        int height = this.getHeight();
        if (startCalendar.get(11) >= 17) {
            currentEndCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5) + 1, 9, 0);
            figure = new HoursBackgroundFigure(timelineModel, startCalendar, currentEndCalendar, false, true, height);
            figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(currentEndCalendar) - this.getXByCalendar(startCalendar), height));
            shadowLayer.add((IFigure)figure);
            figure.revalidate();
            startCalendar.add(5, 1);
        } else {
            currentEndCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5), 9, 0);
            figure = new HoursBackgroundFigure(timelineModel, startCalendar, currentEndCalendar, false, true, height);
            figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(currentEndCalendar) - this.getXByCalendar(startCalendar), height));
            shadowLayer.add((IFigure)figure);
            figure.revalidate();
        }
        startCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5), 17, 0);
        while (startCalendar.before(endCalendar)) {
            currentEndCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5) + 1, 9, 0);
            if (!currentEndCalendar.before(endCalendar)) {
                figure = new HoursBackgroundFigure(timelineModel, startCalendar, endCalendar, true, false, height);
                figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(endCalendar) - this.getXByCalendar(startCalendar), height));
                shadowLayer.add((IFigure)figure);
                figure.revalidate();
                break;
            }
            figure = new HoursBackgroundFigure(timelineModel, startCalendar, currentEndCalendar, true, true, height);
            figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(currentEndCalendar) - this.getXByCalendar(startCalendar), height));
            shadowLayer.add((IFigure)figure);
            figure.revalidate();
            startCalendar.add(5, 1);
        }
    }

    private void refreshDaysBackground(Calendar startCalendar, Calendar endCalendar, TimelineModel timelineModel, boolean isDaysOfWeek) {
        DaysBackgroundFigure figure;
        GregorianCalendar currentEndCalendar;
        Layer shadowLayer = this.getLayer(LAYER_BACKGROUND_SHADOW);
        int height = this.getHeight();
        if (startCalendar.get(7) >= 2 && startCalendar.get(7) <= 6) {
            startCalendar.set(7, 7);
        } else if (startCalendar.get(7) == 7) {
            currentEndCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5) + 2);
            figure = new DaysBackgroundFigure(timelineModel, startCalendar, currentEndCalendar, false, true, height, isDaysOfWeek);
            figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(currentEndCalendar) - this.getXByCalendar(startCalendar), height));
            shadowLayer.add((IFigure)figure);
            figure.revalidate();
            startCalendar.add(3, 1);
        } else {
            currentEndCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5) + 1);
            figure = new DaysBackgroundFigure(timelineModel, startCalendar, currentEndCalendar, false, true, height, isDaysOfWeek);
            figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(currentEndCalendar) - this.getXByCalendar(startCalendar), height));
            shadowLayer.add((IFigure)figure);
            figure.revalidate();
            startCalendar.set(7, 7);
        }
        startCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5));
        while (startCalendar.before(endCalendar)) {
            currentEndCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5) + 2);
            if (!currentEndCalendar.before(endCalendar)) {
                figure = new DaysBackgroundFigure(timelineModel, startCalendar, endCalendar, true, false, height, isDaysOfWeek);
                figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(endCalendar) - this.getXByCalendar(startCalendar), height));
                shadowLayer.add((IFigure)figure);
                figure.revalidate();
                break;
            }
            figure = new DaysBackgroundFigure(timelineModel, startCalendar, currentEndCalendar, true, true, height, isDaysOfWeek);
            figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, this.getXByCalendar(currentEndCalendar) - this.getXByCalendar(startCalendar), height));
            shadowLayer.add((IFigure)figure);
            figure.revalidate();
            startCalendar.add(3, 1);
        }
    }

    private int getXByCalendar(Calendar calendar) {
        TimelineModel timelineModel = ((GanttEditDomain)this.getEditDomain()).getTimelineModel();
        return timelineModel.getPixelsFromMillis(calendar.getTimeInMillis() - timelineModel.getOriginDate().getTimeInMillis());
    }

    private void refreshBackgroundLine() {
        Layer backgroundLineLayer = this.getLayer(LAYER_BACKGROUND_LINE);
        backgroundLineLayer.removeAll();
        int start = this.calculateStart();
        int end = this.calculateEnd();
        TimelineModel timelineModel = ((GanttEditDomain)this.getEditDomain()).getTimelineModel();
        Calendar startCalendar = GregorianCalendar.getInstance();
        startCalendar.setTimeInMillis(timelineModel.getOriginDate().getTimeInMillis() + timelineModel.getMillisFromPixels(start));
        Calendar endCalendar = GregorianCalendar.getInstance();
        endCalendar.setTimeInMillis(timelineModel.getOriginDate().getTimeInMillis() + timelineModel.getMillisFromPixels(end));
        this.refreshBackgroundLine(startCalendar, endCalendar, timelineModel, false);
    }

    private void refreshBackgroundLine(Calendar startCalendar, Calendar endCalendar, TimelineModel timelineModel, boolean isDaysOfWeek) {
        int addFiled = 5;
        double precision = timelineModel.getPrecision();
        if (precision > 5.0 && precision <= 144.0) {
            startCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5), startCalendar.get(10) + 1, 0);
            addFiled = 11;
        } else if (precision <= 3323.0) {
            startCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5) + 1);
            addFiled = 5;
        } else if (precision <= 3456.0) {
            startCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5) + 1);
            addFiled = 5;
        } else if (precision <= 15120.0) {
            startCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5));
            startCalendar.add(3, 1);
            startCalendar.set(7, 1);
            addFiled = 3;
        } else if (precision <= 64800.0) {
            startCalendar = new GregorianCalendar(startCalendar.get(1), startCalendar.get(2) + 1, 1);
            addFiled = 2;
        }
        Layer backgroundLineLayer = this.getLayer(LAYER_BACKGROUND_LINE);
        int height = this.getHeight();
        while (startCalendar.before(endCalendar)) {
            LineFigure figure = new LineFigure();
            figure.setForegroundColor(Colors.split());
            figure.setBounds(new Rectangle(this.getXByCalendar(startCalendar), 0, 1, height));
            backgroundLineLayer.add((IFigure)figure);
            figure.revalidate();
            startCalendar.add(addFiled, 1);
        }
    }

    public void update() {
        this.setInput(this.getInput());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == PopupTaskInfoHelper.class) {
            if (this.popupTaskInfoHelper == null && this.getControl() != null && !this.getControl().isDisposed()) {
                this.popupTaskInfoHelper = new PopupTaskInfoHelper(this);
            }
            return this.popupTaskInfoHelper;
        }
        return super.getAdapter(adapter);
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.popupTaskInfoHelper != null) {
            this.popupTaskInfoHelper.dispose();
            this.popupTaskInfoHelper = null;
        }
        super.handleDispose(e);
    }

    public void setEditDomain(EditDomain editDomain) {
        if (this.getEditDomain() instanceof GanttEditDomain) {
            ((GanttEditDomain)this.getEditDomain()).getTimelineModel().getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        super.setEditDomain(editDomain);
        if (this.getEditDomain() instanceof GanttEditDomain) {
            ((GanttEditDomain)this.getEditDomain()).getTimelineModel().getPropertyChangeSupport().addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Point oldCenter = this.getCenterPoint();
        long oldCenterDate = TimelineModel.calculateMillisFromPixels(oldCenter.x, (Double)evt.getOldValue());
        this.refresh();
        final Point newCenter = new Point(oldCenter);
        newCenter.x = TimelineModel.calculatePixelsFromMillis(oldCenterDate, (Double)evt.getNewValue());
        this.getLightweightSystem().getUpdateManager().runWithUpdate(new Runnable(){

            public void run() {
                TaskBarViewer.this.center(newCenter);
            }
        });
        this.refreshBackgroundLayer();
        this.refreshBackgroundLine();
        this.refreshTimeLine();
        this.refreshTimerTask();
    }

    protected void hookControl(final Control control) {
        super.hookControl(control);
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TaskBarViewer.this.scrollTo(TaskBarViewer.this.getViewport().getHorizontalRangeModel().getMinimum(), 0);
                control.removePaintListener((PaintListener)this);
            }
        });
    }

    public void figureMoved(IFigure source) {
        this.refreshBackgroundLayer();
        this.refreshBackgroundLine();
        this.refreshTimeLine();
    }

    private void createPageContextMenu(Composite container) {
        MenuManager popupMenu = new MenuManager();
        popupMenu.setRemoveAllWhenShown(true);
        String menuId = "org.xmind.ui.gantt.taskBar.popup";
        this.registerPagePopupMenu(menuId, popupMenu);
        container.setMenu(popupMenu.createContextMenu((Control)container));
    }

    private void registerPagePopupMenu(String menuId, MenuManager menu) {
    }

    private static class LineFigure
    extends Figure {
        private LineFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds();
            graphics.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
        }
    }
}

