/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.draw2d.ChopBoxAnchor;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorableFigure;
import org.xmind.gef.draw2d.IAnchorableFigureListener;
import org.xmind.gef.draw2d.ReferencedFigure;

public class AnchorableFigure
extends ReferencedFigure
implements IAnchorableFigure {
    private IAnchor anchor = null;
    private List<IAnchorableFigureListener> ancListners = null;

    public IAnchor getAnchor() {
        if (this.anchor == null) {
            this.anchor = this.createAnchor();
        }
        return this.anchor;
    }

    protected IAnchor createAnchor() {
        return new ChopBoxAnchor(this);
    }

    public void setAnchor(IAnchor anchor) {
        IAnchor oldAnchor;
        if (anchor == null) {
            anchor = this.createAnchor();
        }
        if (anchor == (oldAnchor = this.anchor)) {
            return;
        }
        this.anchor = anchor;
        this.fireAnchorChanged(oldAnchor, anchor);
        this.revalidate();
    }

    public void addAnchorFigureListener(IAnchorableFigureListener listener) {
        if (this.ancListners == null) {
            this.ancListners = new ArrayList<IAnchorableFigureListener>();
        }
        this.ancListners.add(listener);
    }

    public void removeAnchorFigureListener(IAnchorableFigureListener listener) {
        if (this.ancListners == null) {
            return;
        }
        this.ancListners.remove(listener);
    }

    protected void fireAnchorChanged(IAnchor oldAnchor, IAnchor newAnchor) {
        if (this.ancListners == null) {
            return;
        }
        Object[] objectArray = this.ancListners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IAnchorableFigureListener)l).anchorChanged(this, oldAnchor, newAnchor);
            ++n2;
        }
    }
}

