/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.framework.Version;
import org.osgi.impl.bundle.obr.resource.CapabilityImpl;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.RequirementImpl;
import org.osgi.impl.bundle.obr.resource.Tag;
import org.osgi.impl.bundle.obr.resource.VersionRange;
import org.osgi.service.obr.Capability;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resource;
import org.xmlpull.v1.XmlPullParser;

public class ResourceImpl
implements Resource {
    List capabilities = new ArrayList();
    List requirements = new ArrayList();
    URL url;
    String symbolicName;
    VersionRange version;
    List categories = new ArrayList();
    long size = -1L;
    String id;
    static int ID = 1;
    Map map = new HashMap();
    RepositoryImpl repository;
    String presentationName;
    File file;

    public ResourceImpl(RepositoryImpl repository, String name, VersionRange version) {
        this.version = version;
        if (version == null) {
            this.version = new VersionRange("0");
        }
        this.symbolicName = name;
        this.repository = repository;
    }

    public ResourceImpl(RepositoryImpl repository, XmlPullParser parser) throws Exception {
        String v;
        this.repository = repository;
        parser.require(2, null, "resource");
        this.symbolicName = parser.getAttributeValue(null, "symbolicname");
        if (this.symbolicName == null) {
            System.err.println("Hey, no symb name! " + parser.getAttributeValue(null, "uri"));
        }
        this.map.put("symbolicname", this.symbolicName);
        this.presentationName = parser.getAttributeValue(null, "presentationname");
        if (this.presentationName != null) {
            this.map.put("presentationname", this.presentationName);
        }
        if ((v = parser.getAttributeValue(null, "version")) == null) {
            this.setVersion(new VersionRange("0"));
        } else {
            this.setVersion(new VersionRange(v));
        }
        this.setURL(this.toURL(parser.getAttributeValue(null, "uri")));
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("category")) {
                this.categories.add(parser.getAttributeValue(null, "id").trim());
            } else if (parser.getName().equals("require")) {
                this.addRequirement(new RequirementImpl(parser));
            } else if (parser.getName().equals("capability")) {
                this.addCapability(new CapabilityImpl(parser));
            } else {
                String text = parser.nextText();
                if (text != null) {
                    this.map.put(parser.getName(), text.trim());
                }
            }
            parser.next();
        }
        parser.require(3, null, "resource");
    }

    public ResourceImpl(RepositoryImpl impl) {
        this.repository = impl;
    }

    private URL toURL(String attributeValue) throws Exception {
        if (attributeValue == null) {
            return null;
        }
        return new URL(this.repository.getURL(), attributeValue);
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void addCapability(CapabilityImpl capability) {
        if (capability != null) {
            this.capabilities.add(capability);
        }
    }

    public void addRequirement(RequirementImpl requirement) {
        if (requirement != null) {
            this.requirements.add(requirement);
        }
    }

    public void setLicense(URL license) {
        if (license != null) {
            this.map.put("license", license);
        }
    }

    public String getDescription() {
        return (String)this.map.get("description");
    }

    public void setDescription(String description) {
        if (description != null) {
            this.map.put("description", description);
        }
    }

    public Capability[] getCapabilities() {
        return this.capabilities.toArray(new Capability[this.capabilities.size()]);
    }

    public URL getLicense() {
        return (URL)this.map.get("license");
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Requirement[] getRequirements() {
        return this.requirements.toArray(new Requirement[this.requirements.size()]);
    }

    public Tag toXML() {
        return ResourceImpl.toXML(this);
    }

    public static Tag toXML(Resource resource) {
        return ResourceImpl.toXML(resource, true);
    }

    public static Tag toXML(Resource resource, boolean relative) {
        Tag meta = new Tag("resource");
        URL url = resource.getURL();
        String urlString = url.toExternalForm();
        if (relative) {
            urlString = ResourceImpl.makeRelative(resource.getRepository().getURL(), url);
        }
        meta.addAttribute("uri", urlString);
        meta.addAttribute("symbolicname", resource.getSymbolicName());
        if (resource.getPresentationName() != null) {
            meta.addAttribute("presentationname", resource.getPresentationName());
        }
        meta.addAttribute("version", resource.getVersion().toString());
        meta.addAttribute("id", resource.getId());
        TreeMap map = new TreeMap(resource.getProperties());
        int i = 0;
        while (i < Resource.KEYS.length) {
            Object value;
            String key = KEYS[i];
            if (!(key.equals("url") || key.equals("symbolicname") || key.equals("version") || key.equals("presentationname") || (value = map.get(KEYS[i])) == null)) {
                if (value instanceof URL) {
                    value = ResourceImpl.makeRelative(resource.getRepository().getURL(), (URL)value);
                }
                meta.addContent(new Tag(key, value.toString()));
            }
            ++i;
        }
        String[] categories = resource.getCategories();
        int i2 = 0;
        while (i2 < categories.length) {
            String category = categories[i2];
            meta.addContent(new Tag("category", new String[]{"id", category.toLowerCase()}));
            ++i2;
        }
        Capability[] capabilities = resource.getCapabilities();
        int i3 = 0;
        while (i3 < capabilities.length) {
            meta.addContent(CapabilityImpl.toXML(capabilities[i3]));
            ++i3;
        }
        Requirement[] requirements = resource.getRequirements();
        int i4 = 0;
        while (i4 < requirements.length) {
            meta.addContent(RequirementImpl.toXML(requirements[i4]));
            ++i4;
        }
        return meta;
    }

    public URL getURL() {
        return this.url;
    }

    static String makeRelative(URL repository, URL url) {
        try {
            if (repository != null) {
                String a = url.toExternalForm();
                String b = repository.toExternalForm();
                int index = b.lastIndexOf(47);
                if (index > 0) {
                    b = b.substring(0, index + 1);
                }
                if (a.startsWith(b)) {
                    return a.substring(b.length());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url.toExternalForm();
    }

    public void setURL(URL url) {
        this.url = url;
        if (url != null) {
            this.map.put("url", url);
        }
    }

    public String getCopyright() {
        return (String)this.map.get("copyright");
    }

    public Version getVersion() {
        if (this.version == null) {
            this.version = new VersionRange("0");
        }
        return this.version.low;
    }

    void setVersion(VersionRange version) {
        this.version = version == null ? new VersionRange("0") : version;
    }

    public void setCopyright(String copyright) {
        if (copyright != null) {
            this.map.put("copyright", copyright);
        }
    }

    public URL getDocumentation() {
        return (URL)this.map.get("documentation");
    }

    public void setDocumentation(URL documentation) {
        if (documentation != null) {
            this.map.put("documentation", documentation);
        }
    }

    public URL getSource() {
        return (URL)this.map.get("source");
    }

    public void setSource(URL source) {
        if (source != null) {
            this.map.put("source", source);
        }
    }

    public boolean satisfies(RequirementImpl requirement) {
        Iterator i = this.capabilities.iterator();
        while (i.hasNext()) {
            CapabilityImpl capability = (CapabilityImpl)i.next();
            if (!requirement.isSatisfied(capability)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.symbolicName) + "-" + this.version;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
        this.map.put("size", new Long(size));
    }

    public Collection getRequirementList() {
        return this.requirements;
    }

    public Collection getCapabilityList() {
        return this.capabilities;
    }

    public int hashCode() {
        return this.symbolicName.hashCode() ^ this.version.hashCode();
    }

    public boolean equals(Object o) {
        try {
            ResourceImpl other = (ResourceImpl)o;
            return this.symbolicName.equals(other.symbolicName) && this.version.equals(other.version);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String[] getCategories() {
        return this.categories.toArray(new String[this.categories.size()]);
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.map);
    }

    public synchronized String getId() {
        if (this.id == null) {
            this.id = String.valueOf(this.symbolicName) + "/" + this.version;
        }
        return this.id;
    }

    public Repository getRepository() {
        return this.repository;
    }

    void setName(String value) {
        this.symbolicName = value;
    }

    void put(String name, Object value) {
        this.map.put(name, value);
    }

    public void setPresentationName(String name) {
        this.presentationName = name;
        if (name != null) {
            this.map.put("presentationname", name);
        }
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public void setFile(File zipFile) {
        this.file = zipFile;
    }

    public Set getExtendList() {
        HashSet<RequirementImpl> set = new HashSet<RequirementImpl>();
        Iterator i = this.requirements.iterator();
        while (i.hasNext()) {
            RequirementImpl impl = (RequirementImpl)i.next();
            if (!impl.isExtend()) continue;
            set.add(impl);
        }
        return set;
    }
}

