/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.TextWriter;
import org.eclipse.swt.graphics.Color;

abstract class StyledTextWriterBase
extends TextWriter {
    final StyledText styledText;

    public StyledTextWriterBase(StyledText styledText, int start, int length) {
        super(start, length);
        this.styledText = styledText;
    }

    void writeEscaped(String string, int start, int end) {
        String textToWrite = string.substring(start, end);
        this.write(this.escapeText(textToWrite));
    }

    @Override
    public void writeLine(String line, int lineOffset) {
        StyleRange[] styles;
        int[] ranges;
        boolean lineJustify;
        int lineIndent;
        int lineAlignment;
        int verticalIndent;
        if (this.isClosed()) {
            SWT.error(39);
        }
        int lineIndex = this.styledText.content.getLineAtOffset(lineOffset);
        StyledTextEvent event = this.styledText.getLineStyleData(lineOffset, line);
        if (event != null) {
            verticalIndent = event.verticalIndent;
            lineAlignment = event.alignment;
            lineIndent = event.indent;
            lineJustify = event.justify;
            ranges = event.ranges;
            styles = event.styles;
        } else {
            verticalIndent = this.styledText.renderer.getLineVerticalIndent(lineIndex);
            lineAlignment = this.styledText.renderer.getLineAlignment(lineIndex, this.styledText.alignment);
            lineIndent = this.styledText.renderer.getLineIndent(lineIndex, this.styledText.indent);
            lineJustify = this.styledText.renderer.getLineJustify(lineIndex, this.styledText.justify);
            ranges = this.styledText.renderer.getRanges(lineOffset, line.length());
            styles = this.styledText.renderer.getStyleRanges(lineOffset, line.length(), false);
        }
        if (styles == null) {
            styles = new StyleRange[]{};
        }
        Color lineBackground = (event = this.styledText.getLineBackgroundData(lineOffset, line)) != null && event.lineBackground != null ? event.lineBackground : this.styledText.renderer.getLineBackground(lineIndex, null);
        this.writeStyledLine(line, lineOffset, ranges, styles, lineBackground, lineIndent, verticalIndent, lineAlignment, lineJustify);
    }

    void writeStyledLine(String line, int lineOffset, int[] ranges, StyleRange[] styles, Color lineBackground, int indent, int verticalIndent, int alignment, boolean justify) {
        int lineLength = line.length();
        int startOffset = this.getStart();
        int writeOffset = startOffset - lineOffset;
        if (writeOffset >= lineLength) {
            return;
        }
        int lineIndex = Math.max(0, writeOffset);
        String atLineEnd = this.writeLineStart(lineBackground, indent, verticalIndent, alignment, justify);
        int endOffset = startOffset + super.getCharCount();
        if (lineOffset >= endOffset) {
            return;
        }
        int lineEndOffset = Math.min(lineLength, endOffset - lineOffset);
        int outTextLen = 0;
        for (int i = 0; i < styles.length; ++i) {
            int end;
            int start;
            StyleRange style = styles[i];
            if (ranges != null) {
                start = ranges[i << 1] - lineOffset;
                end = start + ranges[(i << 1) + 1];
            } else {
                start = style.start - lineOffset;
                end = start + style.length;
            }
            if (end < writeOffset) continue;
            if (start >= lineEndOffset) break;
            if (lineIndex < start) {
                this.writeEscaped(line, lineIndex, start);
                outTextLen += start - lineIndex;
                lineIndex = start;
            }
            String atSpanEnd = this.writeSpanStart(style);
            int copyEnd = Math.min(end, lineEndOffset);
            copyEnd = Math.max(copyEnd, lineIndex);
            this.writeEscaped(line, lineIndex, copyEnd);
            outTextLen += copyEnd - lineIndex;
            this.writeSpanEnd(atSpanEnd);
            lineIndex = copyEnd;
        }
        if (lineIndex < lineEndOffset) {
            this.writeEscaped(line, lineIndex, lineEndOffset);
            outTextLen += lineEndOffset - lineIndex;
        }
        if (outTextLen == 0) {
            this.writeEmptyLine();
        }
        this.writeLineEnd(atLineEnd);
    }

    abstract void writeHeader();

    abstract String escapeText(String var1);

    abstract String writeLineStart(Color var1, int var2, int var3, int var4, boolean var5);

    void writeLineEnd(String prepared) {
        this.write(prepared);
    }

    abstract void writeEmptyLine();

    abstract String writeSpanStart(StyleRange var1);

    void writeSpanEnd(String prepared) {
        this.write(prepared);
    }
}

