/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.util.Objects;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class ChainedEntityResolver
implements EntityResolver2 {
    private final EntityResolver first;
    private final EntityResolver second;

    public ChainedEntityResolver(EntityResolver first, EntityResolver second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        this.first = first;
        this.second = second;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource is = this.first.resolveEntity(publicId, systemId);
        if (is == null) {
            is = this.second.resolveEntity(publicId, systemId);
        }
        return is;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        InputSource is = null;
        if (this.first instanceof EntityResolver2) {
            is = ((EntityResolver2)this.first).getExternalSubset(name, baseURI);
        }
        if (is == null && this.second instanceof EntityResolver2) {
            is = ((EntityResolver2)this.second).getExternalSubset(name, baseURI);
        }
        return is;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        InputSource is = this.first instanceof EntityResolver2 ? ((EntityResolver2)this.first).resolveEntity(name, publicId, baseURI, systemId) : this.first.resolveEntity(publicId, systemId);
        if (is == null) {
            is = this.second instanceof EntityResolver2 ? ((EntityResolver2)this.second).resolveEntity(name, publicId, baseURI, systemId) : this.second.resolveEntity(publicId, systemId);
        }
        return is;
    }
}

