/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.logging.Logger;

public class Window
extends Panel {
    private DesktopPane desktop;
    Component focusedComponent;
    boolean closeOnFocusLost;
    public int snap;
    private Vector softkeys;
    private ActionListener windowListener;

    public Window() {
        this.setLayout(new BorderLayout());
    }

    public DesktopPane getDesktopPane() {
        if (this.desktop != null) {
            return this.desktop;
        }
        return DesktopPane.getDesktopPane();
    }

    public void setDesktopPane(DesktopPane a) {
        this.desktop = a;
    }

    public void setCloseOnFocusLost(boolean ch) {
        this.closeOnFocusLost = ch;
    }

    public boolean isFocused() {
        return this.desktop != null && this.desktop.getSelectedFrame() == this;
    }

    public Component getFocusOwner() {
        if (!this.isFocused()) {
            return null;
        }
        return this.focusedComponent;
    }

    public Component getMostRecentFocusOwner() {
        if (this.focusedComponent == null && Midlet.getPlatform() != 10) {
            this.breakOutAction(null, 6, false, false);
        }
        return this.focusedComponent;
    }

    public void setNothingFocused() {
        Component f;
        if (Midlet.getPlatform() == 10 && (f = this.getMostRecentFocusOwner()) != null && !(f instanceof TextComponent)) {
            this.setFocusedComponent(null);
        }
    }

    protected void setFocusedComponent(Component ac) {
        Component old = this.focusedComponent;
        this.focusedComponent = ac;
        if (this.focusedComponent != null) {
            this.focusedComponent.repaint();
        } else if (old != null) {
            old.repaint();
        }
    }

    public void setupFocusedComponent() {
        Component c = this.getMostRecentFocusOwner();
        if (!(c == null || c.getWindow() == this && c.isShowing() && c.isFocusable())) {
            this.setFocusedComponent(null);
            this.getMostRecentFocusOwner();
        }
    }

    public void passScrollUpDown(int right) {
        this.breakOutAction(null, right, true, false);
    }

    public void pack() {
        this.workoutPreferredSize();
        this.doLayout();
        this.setupFocusedComponent();
    }

    public void setSize(int width, int height) {
        Vector components = this.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            Component component = (Component)components.elementAt(i);
            component.workoutPreferredSize();
        }
        super.setSize(width, height);
        this.setupFocusedComponent();
    }

    public void addWindowListener(ActionListener al) {
        this.windowListener = al;
    }

    void doClose() {
        if (this.windowListener != null) {
            this.windowListener.actionPerformed("close");
        } else {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.getDesktopPane().add(this);
        } else {
            this.getDesktopPane().remove(this);
        }
    }

    public boolean isVisible() {
        return this.desktop != null && this.desktop.getAllFrames().contains(this);
    }

    public boolean isShowing() {
        return this.isVisible();
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        if (this.closeOnFocusLost && type == 1 && (x < 0 || y < 0 || x > this.width || y > this.height)) {
            this.doClose();
        }
    }

    public Component getComponentAt(int xclick, int yclick) {
        if (this.getDesktopPane().SOFT_KEYS) {
            int x = xclick + this.getXOnScreen();
            int y = yclick + this.getYOnScreen();
            for (int i = 0; i < 5; ++i) {
                int key = 0;
                switch (i) {
                    case 0: {
                        key = -6;
                        break;
                    }
                    case 1: {
                        key = -7;
                        break;
                    }
                    case 2: {
                        key = -5;
                        break;
                    }
                    case 3: {
                        key = -12;
                        break;
                    }
                    case 4: {
                        key = -11;
                    }
                }
                Button b = this.findMnemonicButton(key);
                if (b == null || x < b.getXWithBorder() || x > b.getXWithBorder() + b.getWidthWithBorder() || y < b.getYWithBorder() || y > b.getYWithBorder() + b.getHeightWithBorder()) continue;
                return b;
            }
        }
        return super.getComponentAt(xclick, yclick);
    }

    protected String getDefaultName() {
        return "Window";
    }

    public void paint(Graphics2D g) {
        super.paint(g);
        this.paintSoftKeys(g);
    }

    public void paintSoftKeys(Graphics2D g) {
        if (this.getDesktopPane().SOFT_KEYS && this.isFocused()) {
            int offsetX = g.getTranslateX();
            int offsetY = g.getTranslateY();
            g.translate(-offsetX, -offsetY);
            int menu = -12;
            int back = -11;
            for (int i = 0; i < 5; ++i) {
                Button b;
                int key = 0;
                switch (i) {
                    case 0: {
                        key = -6;
                        break;
                    }
                    case 1: {
                        key = -7;
                        break;
                    }
                    case 2: {
                        key = -5;
                        break;
                    }
                    case 3: {
                        key = menu;
                        break;
                    }
                    case 4: {
                        key = back;
                    }
                }
                if (key == 0 || (b = this.getSoftkeyForMnemonic(key)) == null) continue;
                switch (key) {
                    case -6: {
                        menu = 0;
                        break;
                    }
                    case -7: {
                        back = 0;
                    }
                }
                Component component = this.getRendererComponentOnScreen(b);
                int x = component.getX();
                int y = component.getY();
                g.translate(x, y);
                component.paint(g);
                g.translate(-x, -y);
            }
            g.translate(offsetX, offsetY);
        }
    }

    private Button getSoftkeyForMnemonic(int mnu) {
        if (this.softkeys != null) {
            for (int c = this.softkeys.size() - 1; c >= 0; --c) {
                Button button2;
                Button button = (Button)this.softkeys.elementAt(c);
                if (button.getMnemonic() == mnu) {
                    return button;
                }
                if (!(button instanceof Menu) || (button2 = ((Menu)button).findMneonicButton(mnu)) == null) continue;
                return button2;
            }
        }
        return super.findMnemonicButton(mnu);
    }

    public Component getRendererComponentOnScreen(Button button) {
        DesktopPane dp = this.getDesktopPane();
        boolean sideSoftKeys = dp.isSideSoftKeys();
        int mnemonic = button.getMnemonic();
        int desktopWidth = dp.getWidth();
        int desktopHeight = dp.getHeight();
        Component component = dp.getSoftkeyRenderer().getListCellRendererComponent(null, button, 0, false, false);
        component.workoutPreferredSize();
        int componentWidth = component.getWidthWithBorder();
        int componentHeight = component.getHeightWithBorder();
        int bottom = desktopHeight - componentHeight;
        int right = desktopWidth - componentWidth;
        int x = 0;
        int y = 0;
        if (!(mnemonic != -6 && mnemonic != -12 || sideSoftKeys)) {
            x = 0;
            y = bottom;
        } else if ((mnemonic == -7 || mnemonic == -11) && !sideSoftKeys || (mnemonic == -6 || mnemonic == -12) && sideSoftKeys) {
            x = right;
            y = bottom;
        } else if (mnemonic == -5 && !sideSoftKeys) {
            x = desktopWidth / 2 - componentWidth / 2;
            y = bottom;
        } else if ((mnemonic == -7 || mnemonic == -11) && sideSoftKeys) {
            x = right;
            y = 0;
        } else if (mnemonic == -5 && sideSoftKeys) {
            x = right;
            y = desktopHeight / 2 - componentHeight / 2;
        }
        component.setBoundsWithBorder(x, y, componentWidth, componentHeight);
        return component;
    }

    public void addCommand(Button softkey) {
        if (this.softkeys == null) {
            this.softkeys = new Vector(1);
        }
        if (this.softkeys.contains(softkey)) {
            Logger.warn("whats this all about?");
            throw new RuntimeException();
        }
        this.softkeys.addElement(softkey);
        softkey.parent = this;
        if (softkey == null) {
            Logger.warn("trying to add null button");
            throw new RuntimeException();
        }
        this.softKeyRepaint(softkey);
    }

    private void softKeyRepaint(Button softkey) {
        DesktopPane dp = this.getDesktopPane();
        if (dp.SOFT_KEYS) {
            Component c = this.getRendererComponentOnScreen(softkey);
            dp.repaintHole(c);
        }
    }

    public void removeCommand(Button softkey) {
        if (!this.softkeys.contains(softkey)) {
            Logger.warn("whats this all about?");
            throw new RuntimeException();
        }
        this.softkeys.removeElement(softkey);
        softkey.removeParent(this);
        if (softkey == null) {
            Logger.warn("trying to remove null button");
            throw new RuntimeException();
        }
        this.softKeyRepaint(softkey);
    }

    public Vector getCommands() {
        return this.softkeys == null ? new Vector(0) : this.softkeys;
    }

    public void updateUI() {
        super.updateUI();
        for (int c = 0; this.softkeys != null && c < this.softkeys.size(); ++c) {
            ((Component)this.softkeys.elementAt(c)).updateUI();
        }
    }

    public Button findMnemonicButton(int mn) {
        Button b = this.getSoftkeyForMnemonic(mn);
        if (b != null && !b.isVisible() && this.getDesktopPane().SOFT_KEYS) {
            Component comp = this.getRendererComponentOnScreen(b);
            b.setBoundsWithBorder(comp.getXWithBorder(), comp.getYWithBorder(), comp.getWidthWithBorder(), comp.getHeightWithBorder());
        }
        if (b != null && !b.isVisible() && this.getDesktopPane().HIDDEN_MENU) {
            b.setBoundsWithBorder(0, this.getDesktopPane().getHeight(), this.getDesktopPane().getWidth(), b.getHeightWithBorder());
        }
        return b;
    }

    public void setLocationRelativeTo(Component comp) {
        if (comp == null) {
            DesktopPane dp = this.getDesktopPane();
            this.setLocation((dp.getWidth() - this.getWidth()) / 2, (dp.getHeight() - this.getHeight()) / 2);
        }
    }

    public void makeVisible() {
        DesktopPane dp = this.getDesktopPane();
        int x = this.getXWithBorder();
        int y = this.getYWithBorder();
        int w = this.getWidthWithBorder();
        int h = this.getHeightWithBorder();
        int softkeyHeight = dp.getMenuHeight();
        if (x + w > dp.getWidth()) {
            x = dp.getWidth() - w;
        }
        if (x < 0) {
            x = 0;
        }
        if (y + h > dp.getHeight() - softkeyHeight) {
            y = dp.getHeight() - h - softkeyHeight;
        }
        if (y < softkeyHeight) {
            y = softkeyHeight;
        }
        Border insets = this.getInsets();
        this.setLocation(x + insets.getLeft(), y + insets.getTop());
    }

    public void show(Component invoker, int x, int y) {
        this.pack();
        this.setLocation(x, y);
        this.makeVisible();
        this.setVisible(true);
    }
}

