/*
 * Decompiled with CFR 0.152.
 */
package net.yura.util;

import com.glaforge.i18n.io.SmartEncodingInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Properties;

public class StringsProperties
extends Properties {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final String HEADER = "/* net.yura.util.StringProperties\n";
    static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private Charset encoding = UTF_8;

    /*
     * Enabled aggressive block sorting
     */
    public synchronized CharSequence loadFromStrings(InputStream in) throws IOException, InvalidPropertiesFormatException {
        SmartEncodingInputStream r1 = new SmartEncodingInputStream(in);
        this.encoding = r1.getEncoding();
        if (!UTF_16LE.equals(this.encoding) && !UTF_16BE.equals(this.encoding)) {
            this.encoding = UTF_8;
        }
        PushbackReader r = new PushbackReader(new BufferedReader(new InputStreamReader((InputStream)r1, this.encoding)), HEADER.length());
        StringBuilder comments = new StringBuilder();
        CharBuffer header = CharBuffer.allocate(HEADER.length());
        r.read(header);
        header.rewind();
        if (!HEADER.contentEquals(header)) {
            r.unread(header.array());
        } else {
            int current = r.read();
            int next = r.read();
            while (current != 42 || next != 47) {
                if (next == -1) {
                    throw new InvalidPropertiesFormatException("Unclosed C-style comment");
                }
                comments.append((char)current);
                current = next;
                next = r.read();
            }
        }
        StreamTokenizer st = new StreamTokenizer(r);
        st.slashStarComments(true);
        st.slashSlashComments(true);
        String[] property = new String[2];
        int type = 0;
        block7: while (true) {
            switch (st.nextToken()) {
                case 34: {
                    property[type] = st.sval;
                    break;
                }
                case 61: {
                    type = 1;
                    break;
                }
                case 59: {
                    String old = (String)this.get(property[0]);
                    if (old != null) {
                        System.out.println("key is defined twice: " + property[0]);
                    }
                    this.put(property[0], (old != null ? old : "") + property[1]);
                    type = 0;
                    break;
                }
                case -1: {
                    break block7;
                }
            }
        }
        r.close();
        return comments;
    }

    public synchronized void storeToStrings(OutputStream os, CharSequence comment) throws IOException {
        if (UTF_16LE.equals(this.encoding)) {
            os.write(255);
            os.write(254);
        }
        if (UTF_16BE.equals(this.encoding)) {
            os.write(254);
            os.write(255);
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, this.encoding));
        if (comment != null) {
            w.append(HEADER).append(comment).append("*/\n");
        }
        ArrayList<Object> keys = new ArrayList<Object>(this.keySet());
        Collections.sort(keys);
        Iterator e = keys.iterator();
        while (e.hasNext()) {
            String key = e.next().toString();
            w.append('\"').append(this.saveConvert(key)).append("\" = \"").append(this.saveConvert(this.getProperty(key))).append("\";\n");
        }
        ((Writer)w).close();
    }

    private String saveConvert(String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block7: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block7;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block7;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block7;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block7;
                }
                case '\"': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block7;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }
}

