/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class BuildSrcBuildListenerFactory {
    private final Action<ProjectInternal> buildSrcRootProjectConfiguration;
    private ScriptClassPathResolver resolver;

    public BuildSrcBuildListenerFactory(Action<ProjectInternal> buildSrcRootProjectConfiguration, ScriptClassPathResolver resolver) {
        this.buildSrcRootProjectConfiguration = buildSrcRootProjectConfiguration;
        this.resolver = resolver;
    }

    Listener create() {
        return new Listener(this.buildSrcRootProjectConfiguration, this.resolver);
    }

    public static class Listener
    extends InternalBuildAdapter
    implements EntryTaskSelector {
        private Configuration classpathConfiguration;
        private ProjectState rootProjectState;
        private final Action<ProjectInternal> rootProjectConfiguration;
        private final ScriptClassPathResolver resolver;

        private Listener(Action<ProjectInternal> rootProjectConfiguration, ScriptClassPathResolver resolver) {
            this.rootProjectConfiguration = rootProjectConfiguration;
            this.resolver = resolver;
        }

        public void projectsLoaded(Gradle gradle) {
            GradleInternal gradleInternal = (GradleInternal)gradle;
            gradleInternal.getStartParameter().setTaskRequests(Collections.emptyList());
            ProjectInternal rootProject = gradleInternal.getRootProject();
            this.rootProjectState = rootProject.getOwner();
            this.rootProjectConfiguration.execute((Object)rootProject);
        }

        @Override
        public void applyTasksTo(EntryTaskSelector.Context context, ExecutionPlan plan) {
            this.rootProjectState.applyToMutableState(rootProject -> {
                this.classpathConfiguration = rootProject.getConfigurations().resolvableDependencyScopeUnlocked("buildScriptClasspath");
                this.resolver.prepareClassPath(this.classpathConfiguration, rootProject.getDependencies());
                this.classpathConfiguration.getDependencies().add((Object)rootProject.getDependencies().create(rootProject));
                plan.addEntryTasks(TaskDependencyUtil.getDependenciesForInternalUse((Buildable)this.classpathConfiguration));
            });
        }

        public ClassPath getRuntimeClasspath() {
            return this.rootProjectState.fromMutableState(project -> this.resolver.resolveClassPath(this.classpathConfiguration));
        }
    }
}

