/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.expression;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovyx.gpars.DataflowMessagingRunnable;
import groovyx.gpars.MessagingRunnable;
import groovyx.gpars.actor.Actors;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.dataflow.DataCallbackWithPool;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.expression.DataflowComplexExpression;
import groovyx.gpars.dataflow.expression.DataflowGetPropertyExpression;
import groovyx.gpars.dataflow.expression.DataflowInvocationExpression;
import groovyx.gpars.dataflow.impl.BindErrorListenerManager;
import groovyx.gpars.dataflow.impl.DataflowChannelEventListenerManager;
import groovyx.gpars.dataflow.impl.DataflowChannelEventOrchestrator;
import groovyx.gpars.dataflow.impl.ThenMessagingRunnable;
import groovyx.gpars.dataflow.operator.BinaryChoiceClosure;
import groovyx.gpars.dataflow.operator.ChainWithClosure;
import groovyx.gpars.dataflow.operator.ChoiceClosure;
import groovyx.gpars.dataflow.operator.FilterClosure;
import groovyx.gpars.dataflow.operator.SeparationClosure;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandle;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class DataflowExpression<T>
extends WithSerialId
implements GroovyObject,
DataflowReadChannel<T> {
    private static final String ATTACHMENT = "attachment";
    private static final String RESULT = "result";
    private static final long serialVersionUID = 8961916630562820109L;
    private static final String CANNOT_FIRE_BIND_ERRORS_THE_THREAD_HAS_BEEN_INTERRUPTED = "Cannot fire bind errors - the thread has been interrupted.";
    private static final String A_DATAFLOW_VARIABLE_CAN_ONLY_BE_ASSIGNED_ONCE_ONLY_RE_ASSIGNMENTS_TO_AN_EQUAL_VALUE_ARE_ALLOWED = "A DataflowVariable can only be assigned once. Only re-assignments to an equal value are allowed.";
    private MetaClass metaClass = InvokerHelper.getMetaClass(this.getClass());
    protected volatile T value;
    protected volatile Throwable error;
    protected final AtomicInteger state = new AtomicInteger();
    private final AtomicReference<WaitingThread> waiting = new AtomicReference();
    protected static final int S_NOT_INITIALIZED = 0;
    protected static final int S_INITIALIZING = 1;
    protected static final int S_INITIALIZED = 2;
    private static final WaitingThread dummyWaitingThread = new WaitingThread(null, null, null, null);
    private volatile DataflowChannelEventOrchestrator<T> eventManager;

    protected DataflowExpression() {
        this.state.set(0);
    }

    @Override
    public final boolean isBound() {
        return this.state.get() == 2;
    }

    @Override
    public final int length() {
        return this.isBound() ? 1 : 0;
    }

    @Override
    public void getValAsync(MessageStream callback) {
        this.getValAsync(null, callback);
    }

    @Override
    public void getValAsync(Object attachment, MessageStream callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        WaitingThread newWaiting = null;
        while (this.state.get() != 2) {
            WaitingThread previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(null, null, attachment, callback);
            }
            if ((previous = this.waiting.get()) == dummyWaitingThread) break;
            newWaiting.previous = previous;
            if (!this.waiting.compareAndSet(previous, newWaiting)) continue;
            return;
        }
        this.scheduleCallback(attachment, callback);
    }

    public final void join() throws InterruptedException {
        this.getVal();
    }

    public final void join(long timeout, TimeUnit units) throws InterruptedException {
        this.getVal(timeout, units);
    }

    @Override
    public T getVal() throws InterruptedException {
        WaitingThread newWaiting = null;
        while (this.state.get() != 2) {
            WaitingThread previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(Thread.currentThread(), null, null, null);
            }
            if ((previous = this.waiting.get()) == dummyWaitingThread) break;
            newWaiting.previous = previous;
            if (!this.waiting.compareAndSet(previous, newWaiting)) continue;
            while (this.state.get() != 2) {
                LockSupport.park();
                if (!Thread.currentThread().isInterrupted()) continue;
                DataflowExpression.handleInterruption(newWaiting);
            }
            break block0;
        }
        return this.value;
    }

    @Override
    public T getVal(long timeout, TimeUnit units) throws InterruptedException {
        long endNano = System.nanoTime() + units.toNanos(timeout);
        WaitingThread newWaiting = null;
        while (this.state.get() != 2) {
            WaitingThread previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(Thread.currentThread(), null, null, null);
            }
            if ((previous = this.waiting.get()) == dummyWaitingThread) break;
            newWaiting.previous = previous;
            if (!this.waiting.compareAndSet(previous, newWaiting)) continue;
            while (this.state.get() != 2) {
                long toWait = endNano - System.nanoTime();
                if (toWait <= 0L) {
                    newWaiting.set(true);
                    return null;
                }
                LockSupport.parkNanos(toWait);
                if (!Thread.currentThread().isInterrupted()) continue;
                DataflowExpression.handleInterruption(newWaiting);
            }
            break block0;
        }
        return this.value;
    }

    @Override
    public final DataflowExpression<T> poll() {
        if (this.isBound()) {
            return this;
        }
        return null;
    }

    private static void handleInterruption(AtomicBoolean newWaiting) throws InterruptedException {
        newWaiting.set(true);
        throw new InterruptedException();
    }

    public final void bindSafely(T value) {
        if (!this.state.compareAndSet(0, 1)) {
            this.fireBindError(value, false);
            return;
        }
        this.doBind(value);
    }

    public final void bindError(Throwable e) {
        if (!this.state.compareAndSet(0, 1)) {
            this.fireBindError(e);
            throw new IllegalStateException(A_DATAFLOW_VARIABLE_CAN_ONLY_BE_ASSIGNED_ONCE_ONLY_RE_ASSIGNMENTS_TO_AN_EQUAL_VALUE_ARE_ALLOWED);
        }
        this.error = e;
        this.doBind(null);
    }

    public final void bind(T value) {
        if (!this.state.compareAndSet(0, 1)) {
            try {
                T boundValue = this.getVal();
                if (value == null && boundValue == null) {
                    return;
                }
                if (value != null && value.equals(boundValue)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fireBindError(value, false);
            throw new IllegalStateException(A_DATAFLOW_VARIABLE_CAN_ONLY_BE_ASSIGNED_ONCE_ONLY_RE_ASSIGNMENTS_TO_AN_EQUAL_VALUE_ARE_ALLOWED);
        }
        this.doBind(value);
    }

    public final void bindUnique(T value) {
        if (!this.state.compareAndSet(0, 1)) {
            this.fireBindError(value, true);
            throw new IllegalStateException("A DataflowVariable can only be assigned once. Use bind() to allow for equal values to be passed into already-bound variables.");
        }
        this.doBind(value);
    }

    private void doBind(T value) {
        this.doBindImpl(value);
        this.notifyRemote(null);
    }

    protected void doBindImpl(T value) {
        WaitingThread waitingQueue;
        this.value = value;
        if (value instanceof Throwable) {
            this.error = (Throwable)value;
        }
        this.state.set(2);
        this.fireOnMessage(value);
        WaitingThread currentWaiting = waitingQueue = this.waiting.getAndSet(dummyWaitingThread);
        while (currentWaiting != null) {
            if (currentWaiting.compareAndSet(false, true)) {
                if (currentWaiting.thread != null) {
                    LockSupport.unpark(currentWaiting.thread);
                } else if (currentWaiting.callback != null) {
                    this.scheduleCallback(currentWaiting.attachment, currentWaiting.callback);
                }
            }
            currentWaiting = currentWaiting.previous;
        }
    }

    public final void doBindRemote(UUID hostId, T message) {
        this.doBindImpl(message);
        this.notifyRemote(hostId);
    }

    private void notifyRemote(final UUID hostId) {
        if (this.serialHandle != null) {
            Actors.defaultActorPGroup.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object sub = DataflowExpression.this.serialHandle.getSubscribers();
                    if (sub instanceof RemoteHost) {
                        RemoteHost host = (RemoteHost)sub;
                        if (hostId == null || !host.getHostId().equals(hostId)) {
                            host.write(new BindDataflow(DataflowExpression.this, DataflowExpression.this.value, host.getLocalHost().getId()));
                        }
                    }
                    if (sub instanceof List) {
                        SerialHandle serialHandle = DataflowExpression.this.serialHandle;
                        synchronized (serialHandle) {
                            for (SerialContext host : (List)sub) {
                                if (hostId != null && host.getHostId().equals(hostId)) continue;
                                host.write(new BindDataflow(DataflowExpression.this, DataflowExpression.this.value, host.getLocalHostId()));
                            }
                        }
                    }
                }
            });
        }
    }

    protected void scheduleCallback(Object attachment, MessageStream callback) {
        if (attachment == null) {
            callback.send(this.error != null ? this.error : this.value);
        } else {
            HashMap<String, Object> message = new HashMap<String, Object>(2);
            message.put(ATTACHMENT, attachment);
            message.put(RESULT, this.error != null ? this.error : this.value);
            callback.send(message);
        }
    }

    @Override
    public final <V> Promise<V> rightShift(Closure<V> closure) {
        return this.then(closure);
    }

    @Override
    public final <V> void whenBound(Closure<V> closure) {
        this.getValAsync(new DataCallback(closure, Dataflow.retrieveCurrentDFPGroup()));
    }

    @Override
    public <V> void whenBound(Pool pool, Closure<V> closure) {
        this.getValAsync(new DataCallbackWithPool(pool, closure));
    }

    @Override
    public final <V> void whenBound(PGroup group, Closure<V> closure) {
        this.getValAsync(new DataCallback(closure, group));
    }

    @Override
    public final void whenBound(MessageStream stream) {
        this.getValAsync(stream);
    }

    @Override
    public final <V> Promise<V> then(Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public final <V> Promise<V> then(Pool pool, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(pool, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public final <V> Promise<V> then(PGroup group, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(group, new ThenMessagingRunnable(result, closure));
        return result;
    }

    public final Promise<List> thenForkAndJoin(Closure<? extends Object> ... closures) {
        return this.doThenForkAndJoin(Dataflow.DATA_FLOW_GROUP, Dataflow.DATA_FLOW_GROUP.getThreadPool(), closures);
    }

    public final Promise<List> thenForkAndJoin(Pool pool, Closure<? extends Object> ... closures) {
        return this.doThenForkAndJoin(Dataflow.DATA_FLOW_GROUP, pool, closures);
    }

    public final Promise<List> thenForkAndJoin(PGroup group, Closure<? extends Object> ... closures) {
        return this.doThenForkAndJoin(group, group.getThreadPool(), closures);
    }

    private Promise<List> doThenForkAndJoin(PGroup group, Pool pool, Closure<? extends Object>[] closures) {
        final DataflowVariable<List> result = new DataflowVariable<List>();
        ArrayList<Promise> partialResults = new ArrayList<Promise>(closures.length);
        for (Closure<? extends Object> closure : closures) {
            DataflowVariable partialResult = new DataflowVariable();
            this.whenBound(pool, new ThenMessagingRunnable(partialResult, closure));
            partialResults.add(partialResult);
        }
        group.whenAllBound(partialResults, new DataflowMessagingRunnable(partialResults.size()){

            @Override
            protected void doRun(Object ... arguments) {
                result.bind(Arrays.asList(arguments));
            }
        }, new DataflowMessagingRunnable(1){

            @Override
            protected void doRun(Object ... arguments) {
                result.bindError((Throwable)arguments[0]);
            }
        });
        return result;
    }

    @Override
    public final <V> void wheneverBound(Closure<V> closure) {
        this.whenBound(closure);
    }

    @Override
    public final void wheneverBound(MessageStream stream) {
        this.whenBound(stream);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Closure<V> closure) {
        return this.chainWith(Dataflow.retrieveCurrentDFPGroup(), closure);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Pool pool, Closure<V> closure) {
        return this.chainWith(new DefaultPGroup(pool), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(group, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Map<String, Object> params, Closure<V> closure) {
        return this.chainWith(Dataflow.retrieveCurrentDFPGroup(), params, closure);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Pool pool, Map<String, Object> params, Closure<V> closure) {
        return this.chainWith(new DefaultPGroup(pool), params, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Map<String, Object> params, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(group, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> or(Closure<V> closure) {
        return this.chainWith(closure);
    }

    @Override
    public DataflowReadChannel<T> filter(Closure<Boolean> closure) {
        return this.chainWith(new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Pool pool, Closure<Boolean> closure) {
        return this.chainWith(pool, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(PGroup group, Closure<Boolean> closure) {
        return this.chainWith(group, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Map<String, Object> params, Closure<Boolean> closure) {
        return this.chainWith(params, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Pool pool, Map<String, Object> params, Closure<Boolean> closure) {
        return this.chainWith(pool, params, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(PGroup group, Map<String, Object> params, Closure<Boolean> closure) {
        return this.chainWith(group, params, new FilterClosure(closure));
    }

    @Override
    public void into(DataflowWriteChannel<T> target) {
        this.into(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public void into(Pool pool, DataflowWriteChannel<T> target) {
        this.into(new DefaultPGroup(pool), target);
    }

    @Override
    public void into(PGroup group, final DataflowWriteChannel<T> target) {
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                target.leftShift(argument);
            }
        });
    }

    @Override
    public void into(Map<String, Object> params, DataflowWriteChannel<T> target) {
        this.into(Dataflow.retrieveCurrentDFPGroup(), params, target);
    }

    @Override
    public void into(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> target) {
        this.into(new DefaultPGroup(pool), params, target);
    }

    @Override
    public void into(PGroup group, Map<String, Object> params, final DataflowWriteChannel<T> target) {
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                target.leftShift(argument);
            }
        });
    }

    @Override
    public void or(DataflowWriteChannel<T> target) {
        this.into(target);
    }

    @Override
    public void split(DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), target1, target2);
    }

    @Override
    public void split(Pool pool, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split((PGroup)new DefaultPGroup(pool), target1, target2);
    }

    @Override
    public void split(PGroup group, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(group, Arrays.asList(target1, target2));
    }

    @Override
    public void split(List<DataflowWriteChannel<T>> targets) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), targets);
    }

    @Override
    public void split(Pool pool, List<DataflowWriteChannel<T>> targets) {
        this.split(new DefaultPGroup(pool), targets);
    }

    @Override
    public void split(PGroup group, final List<DataflowWriteChannel<T>> targets) {
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                for (DataflowWriteChannel target : targets) {
                    target.leftShift(argument);
                }
            }
        });
    }

    @Override
    public void split(Map<String, Object> params, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), params, target1, target2);
    }

    @Override
    public void split(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(new DefaultPGroup(pool), params, target1, target2);
    }

    @Override
    public void split(PGroup group, Map<String, Object> params, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(group, params, Arrays.asList(target1, target2));
    }

    @Override
    public void split(Map<String, Object> params, List<DataflowWriteChannel<T>> targets) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), params, targets);
    }

    @Override
    public void split(Pool pool, Map<String, Object> params, List<DataflowWriteChannel<T>> targets) {
        this.split((PGroup)new DefaultPGroup(pool), params, targets);
    }

    @Override
    public void split(PGroup group, Map<String, Object> params, final List<DataflowWriteChannel<T>> targets) {
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                for (DataflowWriteChannel target : targets) {
                    target.leftShift(argument);
                }
            }
        });
    }

    @Override
    public DataflowReadChannel<T> tap(DataflowWriteChannel<T> target) {
        return this.tap(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public DataflowReadChannel<T> tap(Pool pool, DataflowWriteChannel<T> target) {
        return this.tap(new DefaultPGroup(pool), target);
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, final DataflowWriteChannel<T> target) {
        final DataflowVariable result = new DataflowVariable();
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                result.leftShift(argument);
                target.leftShift(argument);
            }
        });
        return result;
    }

    @Override
    public DataflowReadChannel<T> tap(Map<String, Object> params, DataflowWriteChannel<T> target) {
        return this.tap(Dataflow.retrieveCurrentDFPGroup(), params, target);
    }

    @Override
    public DataflowReadChannel<T> tap(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> target) {
        return this.tap(new DefaultPGroup(pool), params, target);
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, Map<String, Object> params, DataflowWriteChannel<T> target) {
        return this.tap(group, target);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(pool, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(group, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge(Dataflow.retrieveCurrentDFPGroup(), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge((PGroup)new DefaultPGroup(pool), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        group.operator(inputs, Arrays.asList(result), new ChainWithClosure(closure));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Map<String, Object> params, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(params, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, Map<String, Object> params, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(pool, params, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, Map<String, Object> params, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(group, params, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Map<String, Object> params, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge(Dataflow.retrieveCurrentDFPGroup(), params, others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, Map<String, Object> params, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge((PGroup)new DefaultPGroup(pool), params, others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, Map<String, Object> params, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", inputs);
        parameters.put("outputs", Arrays.asList(result));
        group.operator(parameters, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public void binaryChoice(DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(Dataflow.retrieveCurrentDFPGroup(), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(Pool pool, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(new DefaultPGroup(pool), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(PGroup group, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        group.operator(Arrays.asList(this), Arrays.asList(trueBranch, falseBranch), (Closure)new BinaryChoiceClosure(code));
    }

    @Override
    public void binaryChoice(Map<String, Object> params, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(Dataflow.retrieveCurrentDFPGroup(), params, trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(new DefaultPGroup(pool), params, trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(PGroup group, Map<String, Object> params, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(trueBranch, falseBranch));
        group.operator(parameters, new BinaryChoiceClosure(code));
    }

    @Override
    public void choice(List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void choice(Pool pool, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void choice(PGroup group, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new ChoiceClosure(code));
    }

    @Override
    public void choice(Map<String, Object> params, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(Dataflow.retrieveCurrentDFPGroup(), params, outputs, code);
    }

    @Override
    public void choice(Pool pool, Map<String, Object> params, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(new DefaultPGroup(pool), params, outputs, code);
    }

    @Override
    public void choice(PGroup group, Map<String, Object> params, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(outputs));
        group.operator(parameters, new ChoiceClosure(code));
    }

    @Override
    public void separate(List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void separate(Pool pool, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void separate(PGroup group, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new SeparationClosure(code));
    }

    @Override
    public void separate(Map<String, Object> params, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(Dataflow.retrieveCurrentDFPGroup(), params, outputs, code);
    }

    @Override
    public void separate(Pool pool, Map<String, Object> params, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(new DefaultPGroup(pool), params, outputs, code);
    }

    @Override
    public void separate(PGroup group, Map<String, Object> params, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(outputs));
        group.operator(parameters, new SeparationClosure(code));
    }

    @Override
    public synchronized DataflowChannelEventListenerManager<T> getEventManager() {
        return this.createEventManager();
    }

    public synchronized BindErrorListenerManager<T> getBindErrorManager() {
        return this.createEventManager();
    }

    private DataflowChannelEventOrchestrator<T> createEventManager() {
        if (this.eventManager != null) {
            return this.eventManager;
        }
        this.eventManager = new DataflowChannelEventOrchestrator();
        return this.eventManager;
    }

    private void fireOnMessage(T value) {
        if (this.eventManager != null) {
            this.eventManager.fireOnMessage(value);
        }
    }

    private void fireBindError(T value, boolean unique) {
        if (this.eventManager != null) {
            try {
                T oldValue = this.getVal();
                Throwable error = this.error;
                if (error == null) {
                    this.eventManager.fireBindError(oldValue, value, unique);
                } else {
                    this.eventManager.fireBindError(error, value, unique);
                }
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(CANNOT_FIRE_BIND_ERRORS_THE_THREAD_HAS_BEEN_INTERRUPTED, ex);
            }
        }
    }

    private void fireBindError(Throwable e) {
        if (this.eventManager != null) {
            try {
                T oldValue = this.getVal();
                Throwable error = this.error;
                if (error == null) {
                    this.eventManager.fireBindError(oldValue, e);
                } else {
                    this.eventManager.fireBindError(error, e);
                }
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(CANNOT_FIRE_BIND_ERRORS_THE_THREAD_HAS_BEEN_INTERRUPTED, ex);
            }
        }
    }

    public static <V> DataflowExpression<V> transform(Object another, Closure closure) {
        int pnum = closure.getMaximumNumberOfParameters();
        if (pnum == 0) {
            throw new IllegalArgumentException("Closure should have parameters");
        }
        if (pnum == 1) {
            return new TransformOne(another, closure);
        }
        if (another instanceof Collection) {
            Collection collection = (Collection)another;
            if (collection.size() != pnum) {
                throw new IllegalArgumentException("Closure parameters don't match the # of arguments");
            }
            return new TransformMany(collection, closure);
        }
        throw new IllegalArgumentException("Collection expected");
    }

    protected final void subscribe() {
        DataflowExpressionsCollector listener = new DataflowExpressionsCollector();
        this.subscribe(listener);
        listener.start();
    }

    protected T evaluate() {
        return this.value;
    }

    protected void subscribe(DataflowExpressionsCollector listener) {
        listener.subscribe(this);
    }

    public final Object invokeMethod(String name, Object args) {
        if (this.getMetaClass().respondsTo((Object)this, name).isEmpty()) {
            return new DataflowInvocationExpression((Object)this, name, (Object[])args);
        }
        return InvokerHelper.invokeMethod((Object)this, (String)name, (Object)args);
    }

    public final Object getProperty(String propertyName) {
        MetaProperty metaProperty = this.getMetaClass().hasProperty((Object)this, propertyName);
        if (metaProperty != null) {
            return metaProperty.getProperty((Object)this);
        }
        return new DataflowGetPropertyExpression(this, propertyName);
    }

    public final void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public final void setProperty(String propertyName, Object newValue) {
        this.metaClass.setProperty((Object)this, propertyName, newValue);
    }

    public final MetaClass getMetaClass() {
        return this.metaClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(value=" + this.value + ')';
    }

    public static class BindDataflow<T>
    extends SerialMsg {
        private static final long serialVersionUID = -8674023870562062769L;
        private final DataflowExpression<T> expr;
        private final T message;

        public BindDataflow(DataflowExpression<T> expr, T message, UUID hostId) {
            super(hostId);
            this.expr = expr;
            this.message = message;
        }

        @Override
        public void execute(RemoteConnection conn) {
            this.expr.doBindRemote(this.hostId, this.message);
        }
    }

    private static class TransformMany<V>
    extends DataflowComplexExpression<V> {
        private static final long serialVersionUID = 4115456542358280855L;
        private final Closure closure;

        private TransformMany(Collection<?> collection, Closure closure) {
            super(collection.toArray());
            this.closure = closure;
            this.subscribe();
        }

        @Override
        protected V evaluate() {
            super.evaluate();
            return (V)this.closure.call(this.args);
        }
    }

    private static class TransformOne<V>
    extends DataflowExpression<V> {
        private static final long serialVersionUID = 6701886501249351047L;
        Object arg;
        private final Closure closure;

        private TransformOne(Object another, Closure closure) {
            this.closure = closure;
            this.arg = another;
        }

        @Override
        protected V evaluate() {
            return (V)this.closure.call(this.arg instanceof DataflowExpression ? ((DataflowExpression)this.arg).value : this.arg);
        }

        @Override
        protected void subscribe(DataflowExpressionsCollector listener) {
            this.arg = listener.subscribe(this.arg);
        }
    }

    final class DataflowExpressionsCollector
    extends MessageStream {
        private static final long serialVersionUID = 3414942165521113575L;
        private final AtomicInteger count = new AtomicInteger(1);

        DataflowExpressionsCollector() {
        }

        @Override
        public MessageStream send(Object message) {
            if (this.count.decrementAndGet() == 0) {
                DataflowExpression.this.bind(DataflowExpression.this.evaluate());
            }
            return this;
        }

        Object subscribe(Object element) {
            if (!(element instanceof DataflowExpression)) {
                return element;
            }
            DataflowExpression dataflowExpression = (DataflowExpression)element;
            if (dataflowExpression.state.get() == 2) {
                return dataflowExpression.value;
            }
            this.count.incrementAndGet();
            dataflowExpression.getValAsync(this);
            return element;
        }

        void start() {
            if (this.count.decrementAndGet() == 0) {
                DataflowExpression.this.doBind(DataflowExpression.this.evaluate());
            }
        }
    }

    private static final class WaitingThread
    extends AtomicBoolean {
        private static final long serialVersionUID = 8909974768784947460L;
        private final Thread thread;
        private volatile WaitingThread previous;
        private final MessageStream callback;
        private final Object attachment;

        private WaitingThread(Thread thread, WaitingThread previous, Object attachment, MessageStream callback) {
            this.callback = callback;
            this.attachment = attachment;
            this.thread = thread;
            this.previous = previous;
        }
    }
}

