/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;

public class FileSelectionTextField
extends JPanel {
    private JButton m_buttonFileSelection;
    private JFileChooser m_fileChooser;
    private JTextField m_filename;
    private File m_basedir = null;
    private Vector m_listeners = new Vector();

    public FileSelectionTextField() {
        this.m_fileChooser = new JFileChooser();
        this.m_filename = new JTextField();
        this.m_buttonFileSelection = new JButton();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_filename, "Center");
        this.m_buttonFileSelection.setText("...");
        this.m_buttonFileSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSelectionTextField.this.buttonFileSelectionActionPerformed(evt);
            }
        });
        this.m_filename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (FileSelectionTextField.this.m_filename.getText().length() > 0) {
                    FileSelectionTextField.this.setFile(new File(FileSelectionTextField.this.m_filename.getText()));
                } else {
                    FileSelectionTextField.this.setFile(null);
                }
                FileSelectionTextField.this.notifyListeners(FileSelectionTextField.this.m_filename.getText());
            }
        });
        this.m_filename.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (FileSelectionTextField.this.m_filename.getText().length() > 0) {
                    FileSelectionTextField.this.setFile(new File(FileSelectionTextField.this.m_filename.getText()));
                } else {
                    FileSelectionTextField.this.setFile(null);
                }
                FileSelectionTextField.this.notifyListeners(FileSelectionTextField.this.m_filename.getText());
            }
        });
        this.add((Component)this.m_buttonFileSelection, "East");
    }

    public void addListener(FileSelected fs) {
        this.m_listeners.add(fs);
    }

    public void removeListener(FileSelected fs) {
        this.m_listeners.remove(fs);
    }

    public void notifyListeners(String filename) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            FileSelected fs = (FileSelected)this.m_listeners.get(i);
            fs.fileSelected(filename);
        }
    }

    private void buttonFileSelectionActionPerformed(ActionEvent evt) {
        String fname = this.m_filename.getText().trim();
        File cur = new File(fname);
        if (!cur.isAbsolute() && this.m_basedir != null) {
            cur = new File(this.m_basedir, cur.toString()).getAbsoluteFile();
            try {
                cur = cur.getCanonicalFile();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
        this.m_fileChooser.setSelectedFile(cur);
        if (this.m_fileChooser.showDialog(this, "Select") == 0) {
            File f = this.m_fileChooser.getSelectedFile();
            if (this.m_basedir != null) {
                File rel = JSmoothModelPersistency.makePathRelativeIfPossible(this.m_basedir, f);
                this.m_filename.setText(rel.toString());
                this.notifyListeners(rel.toString());
            } else {
                this.m_filename.setText(f.getAbsolutePath());
                this.notifyListeners(f.getAbsolutePath());
            }
        }
    }

    public void setFile(File f) {
        if (f == null) {
            this.m_filename.setText("");
        } else if (this.m_basedir != null) {
            try {
                File rel = JSmoothModelPersistency.makePathRelativeIfPossible(this.m_basedir, f);
                this.m_filename.setText(rel.toString());
            }
            catch (Throwable thr) {
                this.m_filename.setText(f.toString());
            }
        } else {
            this.m_filename.setText(f.toString());
        }
    }

    public File getFile() {
        if (this.m_filename.getText().trim().length() == 0) {
            return null;
        }
        return new File(this.m_filename.getText());
    }

    public void setFileChooser(JFileChooser jfc) {
        this.m_fileChooser = jfc;
    }

    public void setFileSelectionMode(int mode) {
        this.m_fileChooser.setFileSelectionMode(mode);
    }

    public void setBaseDir(File root) {
        this.m_fileChooser.setCurrentDirectory(root);
        this.m_basedir = root;
    }

    public File getBaseDir() {
        return this.m_basedir;
    }

    public void setEnabled(boolean b) {
        this.m_buttonFileSelection.setEnabled(b);
        this.m_filename.setEnabled(b);
    }

    public static interface FileSelected {
        public void fileSelected(String var1);
    }
}

