/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.xml.stream.XMLStreamException;
import jrm.locale.Messages;
import jrm.profile.data.AnywareListList;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Driver;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineList;
import jrm.profile.data.SoftwareListList;
import jrm.profile.manager.Export;
import jrm.ui.profile.data.AnywareListListRenderer;
import jrm.ui.progress.ProgressHandler;
import jrm.xml.EnhancedXMLStreamWriter;
import org.apache.commons.io.IOUtils;

public final class MachineListList
extends AnywareListList<MachineList>
implements Serializable {
    private final List<MachineList> ml_list = Collections.singletonList(new MachineList());
    public final SoftwareListList softwarelist_list = new SoftwareListList();
    public final Map<String, List<Machine>> softwarelist_defs = new HashMap<String, List<Machine>>();

    public MachineListList() {
        this.initTransient();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }

    @Override
    protected void initTransient() {
        super.initTransient();
    }

    @Override
    public int getColumnCount() {
        return AnywareListListRenderer.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return AnywareListListRenderer.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return AnywareListListRenderer.columnsTypes[columnIndex];
    }

    @Override
    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return AnywareListListRenderer.columnsRenderers[columnIndex] != null ? AnywareListListRenderer.columnsRenderers[columnIndex] : new DefaultTableCellRenderer();
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return AnywareListListRenderer.columnsWidths[columnIndex];
    }

    @Override
    public void reset() {
        this.filtered_list = null;
        this.fireTableChanged(new TableModelEvent(this));
        this.softwarelist_list.reset();
    }

    @Override
    public void setFilter(EnumSet<AnywareStatus> filter) {
        AnywareListList.filter = filter;
        this.reset();
    }

    @Override
    public int getRowCount() {
        return this.ml_list.size() + this.softwarelist_list.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.ml_list.size()) {
            switch (columnIndex) {
                case 0: {
                    return this.ml_list.get(rowIndex);
                }
                case 1: {
                    return Messages.getString("MachineListList.AllMachines");
                }
                case 2: {
                    return String.format("%d/%d", this.ml_list.get(rowIndex).countHave(), this.ml_list.get(rowIndex).countAll());
                }
            }
        } else {
            return this.softwarelist_list.getValueAt(rowIndex - this.ml_list.size(), columnIndex);
        }
        return null;
    }

    @Override
    public List<MachineList> getList() {
        return this.ml_list;
    }

    @Override
    public Stream<MachineList> getFilteredStream() {
        return this.getList().stream();
    }

    @Override
    protected List<MachineList> getFilteredList() {
        if (this.filtered_list == null) {
            this.filtered_list = this.getFilteredStream().filter(t -> AnywareListList.filter.contains(t.getStatus())).sorted().collect(Collectors.toList());
        }
        return this.filtered_list;
    }

    public List<Machine> getSortedMachines(String softwarelist, String compatibility) {
        if (this.softwarelist_defs.containsKey(softwarelist)) {
            return this.softwarelist_defs.get(softwarelist).stream().filter(m -> m.isCompatible(softwarelist, compatibility) > 0).sorted((o1, o2) -> {
                int c1 = o1.isCompatible(softwarelist, compatibility);
                int c2 = o2.isCompatible(softwarelist, compatibility);
                if (o1.driver.getStatus() == Driver.StatusType.good) {
                    c1 += 2;
                }
                if (o1.driver.getStatus() == Driver.StatusType.imperfect) {
                    ++c1;
                }
                if (o2.driver.getStatus() == Driver.StatusType.good) {
                    c2 += 2;
                }
                if (o2.driver.getStatus() == Driver.StatusType.imperfect) {
                    ++c2;
                }
                if (c1 < c2) {
                    return 1;
                }
                if (c1 > c2) {
                    return -1;
                }
                return 0;
            }).collect(Collectors.toList());
        }
        return null;
    }

    public Machine findMachine(String softwarelist, String compatibility) {
        if (this.softwarelist_defs.containsKey(softwarelist)) {
            return this.getSortedMachines(softwarelist, compatibility).stream().findFirst().orElse(null);
        }
        return null;
    }

    public void export(EnhancedXMLStreamWriter writer, ProgressHandler progress, boolean is_mame, boolean filtered) throws XMLStreamException, IOException {
        List lists = this.getFilteredStream().collect(Collectors.toList());
        if (lists.size() > 0) {
            writer.writeStartDocument("UTF-8", "1.0");
            if (is_mame) {
                writer.writeDTD("<!DOCTYPE mame [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/mame.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
            } else {
                writer.writeDTD("<!DOCTYPE datafile [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/datafile.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
            }
            for (MachineList list : lists) {
                list.export(writer, progress, is_mame, filtered);
            }
            writer.writeEndDocument();
        }
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return AnywareListListRenderer.columnsRenderers;
    }
}

