/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AbstractPrologEngine;
import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.TermModel;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.IPInterruptedException;
import com.declarativa.interprolog.util.VariableNode;
import java.awt.Container;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFrame;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class PrologEngineTest
extends TestCase {
    public AbstractPrologEngine engine = null;
    protected int thisID;
    boolean didInterrupt;
    static final float SMALL_FLOAT_VALUE = -3.14159f;
    static final float LARGE_FLOAT_VALUE = 181.25f;
    boolean secondThreadArrived = false;
    boolean firstThreadWoke = false;
    static /* synthetic */ Class class$com$declarativa$interprolog$AbstractPrologEngine;

    public PrologEngineTest(String string) {
        super(string);
    }

    public void loadTestFile() {
        this.engine.consultFromPackage("tests.P", class$com$declarativa$interprolog$AbstractPrologEngine != null ? class$com$declarativa$interprolog$AbstractPrologEngine : (class$com$declarativa$interprolog$AbstractPrologEngine = PrologEngineTest.class$("com.declarativa.interprolog.AbstractPrologEngine")));
    }

    protected abstract AbstractPrologEngine buildNewEngine();

    public void testNewInterrupt() {
        this.didInterrupt = false;
        1 var1_1 = new 1();
        System.out.println("Starting thread with goal to be interrupted...");
        var1_1.start();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        System.out.println("About to interrupt...");
        this.engine.interrupt();
        System.out.println("Starting loop...");
        while (!this.didInterrupt) {
            Thread.yield();
        }
        System.out.println("Finished loop...");
        Object object = this.engine.deterministicGoal("R=string(still_alive)", "[R]")[0];
        Assert.assertEquals((Object)object, (Object)"still_alive");
    }

    public void testNumbers() {
        ObjectExamplePair[] objectExamplePairArray = new ObjectExamplePair[]{NumberTypes.example()};
        Assert.assertTrue((String)"Sent NumberTypes examples", (boolean)this.engine.teachMoreObjects(objectExamplePairArray));
        this.engine.waitUntilIdle();
        String string = "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$NumberTypes',Min,[SmallByte,SmallFloat,SmallInt,SmallShort],_), ipProgressMessage(gOT-[SmallByte,SmallFloat,SmallInt,SmallShort]), ";
        string = String.valueOf(string) + "ipProgressMessage(got_here), ";
        string = String.valueOf(string) + "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$NumberTypes',Max,[127,LargeFloat,134217727,32767],_),";
        string = String.valueOf(string) + "ipProgressMessage(got_there), ";
        string = String.valueOf(string) + "DeltaSmall is SmallFloat - (-3.14159),DeltaLarge is LargeFloat - 181.25, DeltaSmall*DeltaSmall<0.001, DeltaLarge*DeltaLarge<0.001";
        NumberTypes numberTypes = new NumberTypes(-128, Short.MIN_VALUE, -134217728, -3.14159f);
        NumberTypes numberTypes2 = new NumberTypes(127, Short.MAX_VALUE, 0x7FFFFFF, 181.25f);
        Object[] objectArray = new Object[]{numberTypes, numberTypes2};
        Assert.assertTrue((String)"Numbers well sent and understood", (boolean)this.engine.deterministicGoal(string, "[Min,Max]", objectArray));
        string = "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$NumberTypes',Min,[";
        string = String.valueOf(string) + "-128,-3.14159,-134217728,-32768],_), ";
        string = String.valueOf(string) + "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$NumberTypes',Max,[";
        string = String.valueOf(string) + "127,181.25,134217727,32767],_)";
        Object[] objectArray2 = this.engine.deterministicGoal(string, "[Min,Max]");
        Assert.assertEquals((String)"MIN arrived well", (Object)numberTypes, (Object)objectArray2[0]);
        Assert.assertEquals((String)"MAX arrived well", (Object)numberTypes2, (Object)objectArray2[1]);
    }

    public void testPrototypeStuff() {
        this.engine.teachOneObject(new MyClass());
        String string = "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$MyClass',[one=1,two=2],Obj)";
        string = String.valueOf(string) + ", ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$MyClass',[one=One,two=Two],Obj), Three is One+Two, ";
        string = String.valueOf(string) + "ipObjectSpec('java.lang.Integer',[value=Three],Integer)";
        Object[] objectArray = this.engine.deterministicGoal(string, "[Obj,Integer]");
        MyClass myClass = (MyClass)objectArray[0];
        Assert.assertTrue((myClass.one == 1 ? 1 : 0) != 0);
        Assert.assertTrue((myClass.two == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)new Integer(3), (Object)objectArray[1]);
    }

    public void testAutoTermModel() {
        Object[] objectArray = this.engine.deterministicGoal("X=1,Y=hello(complex(term))", null);
        Assert.assertEquals((int)objectArray.length, (int)1);
        Assert.assertTrue((boolean)(objectArray[0] instanceof TermModel));
    }

    public void testBuildTermModel() {
        TermModel termModel = (TermModel)this.engine.deterministicGoal("buildTermModel(a(b,c(1)),Model)", "[Model]")[0];
        Assert.assertEquals((String)"a(b,c(1))", (String)termModel.toString());
        Assert.assertEquals((String)"a(_,_)", (String)termModel.getTemplate());
        Assert.assertEquals((int)2, (int)termModel.getChildCount());
        TermModel termModel2 = (TermModel)this.engine.deterministicGoal("buildTermModel(a(X,c(X)),Model)", "[Model]")[0];
        TermModel termModel3 = (TermModel)termModel2.getChild(0);
        Assert.assertTrue((String)"Child is var", (boolean)termModel3.isVar());
        Object object = termModel2.clone();
        Assert.assertEquals((String)termModel2.toString(), (String)object.toString());
        termModel2.assignToVar((VariableNode)termModel3.node, "someX");
        Assert.assertEquals((String)"a(someX,c(someX))", (String)termModel2.toString());
        Object[] objectArray = new Object[]{termModel2, object};
        String string = "recoverTermModel(Model3,T3), arg(1,T3,X), arg(2,T3,c(XX)), XX==X, recoverTermModel(Model2,T2), T2=T3, ";
        string = String.valueOf(string) + "arg(1,T2,someX), functor(T2,F,N), ipObjectSpec('java.lang.Integer',Integer,[N],_)";
        Object[] objectArray2 = this.engine.deterministicGoal(string, "[Model2,Model3]", objectArray, "[string(F),Integer]");
        Assert.assertTrue((objectArray2 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"a", (Object)objectArray2[0]);
        Assert.assertEquals((Object)new Integer(2), (Object)objectArray2[1]);
    }

    public void testNumbers2() {
        Object[] objectArray = new Object[]{new Float(16.25), new Float(0.0), new Float(15.5)};
        Object[] objectArray2 = this.engine.deterministicGoal("append([97,98],[99,100],L), length(L,N), ipObjectSpec('java.lang.Integer',Integer,[N],_), name(A,L),assert(foofoo(Objects))", "Objects", objectArray, "[Integer,string(A)]");
        Assert.assertTrue((String)"Got a result", (objectArray2 != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"First result", (Object)objectArray2[0], (Object)new Integer(4));
        Assert.assertEquals((String)"Second result", (Object)objectArray2[1], (Object)"abcd");
        Object[] objectArray3 = this.engine.deterministicGoal("foofoo([F1,F2,F3])", "[F1,F2,F3]");
        this.engine.setDebug(false);
        Assert.assertTrue((String)"succeeded", (objectArray3 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)objectArray3[0], (Object)new Float(16.25));
        Assert.assertEquals((Object)objectArray3[1], (Object)new Float(0.0));
        Assert.assertEquals((String)"Third float OK", (Object)objectArray3[2], (Object)new Float(15.5));
    }

    public void testDeterministicGoal() {
        Object object;
        Assert.assertTrue((boolean)this.engine.deterministicGoal("true"));
        this.engine.waitUntilAvailable();
        try {
            this.engine.deterministicGoal("true", "[foo]");
            Assert.fail((String)"should raise an IPException due to grammar failure");
        }
        catch (IPException iPException) {
            Assert.assertTrue((String)("IPException should complain about bad object specification:" + iPException), (iPException.toString().indexOf(" specification") != -1 ? 1 : 0) != 0);
        }
        try {
            this.engine.deterministicGoal("true", "[[_]]");
            Assert.fail((String)"should raise an IPException due to grammar failure");
        }
        catch (IPException iPException) {
            Assert.assertTrue((String)("IPException should complain about spec. of result bindings:" + iPException), (iPException.toString().indexOf("bindings") != -1 ? 1 : 0) != 0);
        }
        try {
            object = this.engine.deterministicGoal("true", "[_]");
            System.out.println("R:" + object[0]);
            Assert.fail((String)"should raise an IPException due to bad object specification");
        }
        catch (IPException iPException) {
            Assert.assertTrue((String)("IPException should complain about bad object specification:" + iPException), (iPException.toString().indexOf(" specification") != -1 ? 1 : 0) != 0);
        }
        try {
            this.engine.deterministicGoal("bad goal");
            Assert.fail((String)"should raise an IPException with syntax error");
        }
        catch (IPException iPException) {
            Assert.assertTrue((String)("IPException should denote syntax error:" + iPException), (iPException.toString().indexOf("Syntax") != -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Engine ready2", (boolean)this.engine.isIdle());
        Assert.assertTrue((String)"Engine working", (boolean)this.engine.deterministicGoal("true"));
        try {
            this.engine.deterministicGoal("true", "BadResultsList");
            Assert.fail((String)"should raise an IPException complaining about lack of a Prolog list");
        }
        catch (IPException iPException) {}
        Assert.assertTrue((String)"Engine ready1", (boolean)this.engine.isIdle());
        object = new Vector();
        Object[] objectArray = new Object[]{new Integer(16), new Short(0), new Byte(15)};
        ((Vector)object).addElement(objectArray);
        ((Vector)object).addElement("Hello there");
        int n = 0;
        while (n < 30) {
            Vector<Integer> vector = new Vector<Integer>();
            int n2 = 0;
            while (n2 < 100) {
                vector.addElement(new Integer(n2));
                ++n2;
            }
            ((Vector)object).addElement(vector);
            ++n;
        }
        this.engine.waitUntilAvailable();
        long l = System.currentTimeMillis();
        Object[] objectArray2 = new Object[]{object};
        String string = "streamContents([Object],handles(NH,_),Bytes,[]), length(Bytes,NB), ";
        string = String.valueOf(string) + "ipObjectSpec('java.lang.Integer',IntegerNH,[NH],_), ipObjectSpec('java.lang.Integer',IntegerNB,[NB],_)";
        Object[] objectArray3 = this.engine.deterministicGoal(string, "[Object]", objectArray2, "[Object,IntegerNH,IntegerNB]");
        long l2 = System.currentTimeMillis() - l;
        int n3 = (Integer)objectArray3[2];
        System.out.println("Bulk torture took " + l2 + " mS (" + (long)(1000 * n3) / l2 + " bytes gone and returned / second)");
        Assert.assertEquals((Object)new Integer(3073), (Object)objectArray3[1]);
        if (System.getProperty("java.version").compareTo("1.4.2") >= 0) {
            Assert.assertEquals((Object)new Integer(32906), (Object)objectArray3[2]);
        } else {
            Assert.assertEquals((Object)new Integer(32843), (Object)objectArray3[2]);
        }
        Assert.assertTrue((boolean)(objectArray3[0] instanceof Vector));
        l = System.currentTimeMillis();
        int n4 = 3;
        int n5 = 0;
        while (n5 < n4) {
            Assert.assertTrue((boolean)this.engine.deterministicGoal("true"));
            ++n5;
        }
        System.out.println("Busy torture took " + (System.currentTimeMillis() - l) / (long)n4 + " mS/goal");
    }

    public void testDG2() {
        String string = "(X=a;X=b)";
        String string2 = "X";
        String string3 = "findall(TM, (" + string + ",buildTermModel(" + string2 + ",TM)), L), ipObjectSpec('ArrayOfObject',L,LM)";
        Object[] objectArray = (Object[])this.engine.deterministicGoal(string3, "[LM]")[0];
        Assert.assertEquals((int)2, (int)objectArray.length);
        Assert.assertEquals((String)"a", (String)objectArray[0].toString());
    }

    public int luckyNumber() {
        return 13;
    }

    public void testJavaMessage() {
        Assert.assertEquals((int)this.engine.registerJavaObject((Object)this), (int)this.thisID);
        String string = "javaMessage(" + this.thisID + ",R,luckyNumber), ipObjectSpec('java.lang.Integer',R,[13],_)";
        Assert.assertTrue((String)"Succeeded 1st", (boolean)this.engine.deterministicGoal(string));
        String string2 = "assert((tortureJM(0) :- !)), ";
        string2 = String.valueOf(string2) + "assert((tortureJM(N) :- NN is N-1, " + string + ", tortureJM(NN)))";
        Assert.assertTrue((String)"Succeeded 2nd", (boolean)this.engine.deterministicGoal(string2));
        long l = System.currentTimeMillis();
        int n = 10;
        Assert.assertTrue((String)"Succeeded torture", (boolean)this.engine.deterministicGoal("tortureJM(" + n + ")"));
        System.out.println("Callback torture took " + (System.currentTimeMillis() - l) / (long)n + " mS/message");
    }

    public void testIPobjects() {
        Assert.assertTrue((boolean)this.engine.deterministicGoal("assert(myListLength([],0))"));
        Assert.assertTrue((boolean)this.engine.deterministicGoal("assert((myListLength([_|L],N):-myListLength(L,NN),N is NN+1))"));
        String string = "findall(foo,ipObjectSpec(_,_,_,_), L), myListLength(L,_N), ";
        string = String.valueOf(string) + "findall(foo,ipObjectTemplate(_,_,_,_,_), LL), myListLength(LL,_N), ";
        string = String.valueOf(string) + "ipObjectSpec('java.lang.Integer',Integer,[_N],_) ";
        Integer n = (Integer)this.engine.deterministicGoal(string, "[Integer]")[0];
        Assert.assertTrue((n > 20 ? 1 : 0) != 0);
    }

    public void testLoops() {
        Loop loop;
        this.engine.teachOneObject(new Loop());
        loop.next = loop = new Loop();
        Assert.assertTrue((boolean)this.engine.deterministicGoal("true", "[L]", new Object[]{loop}));
    }

    public int somaN(int n) {
        Object[] objectArray = this.engine.deterministicGoal("somaN(" + n + ",X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        return (Integer)objectArray[0];
    }

    public void testSomaN() {
        this.engine.waitUntilIdle();
        this.engine.command("ipObjectSpec('InvisibleObject',_T,[" + this.thisID + "],_)," + "assert(ipSomaN(_T))");
        this.engine.waitUntilIdle();
        Object[] objectArray = this.engine.deterministicGoal("somaN(10,X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        Integer n = (Integer)objectArray[0];
        Assert.assertTrue((String)"Got a result", (objectArray != null ? 1 : 0) != 0);
        this.engine.progressMessage("result: " + objectArray[0]);
        Assert.assertEquals((String)"First result", (Object)n, (Object)new Integer(55));
    }

    public int fibonaci(int n) {
        Object[] objectArray = this.engine.deterministicGoal("fib(" + n + ",X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        return (Integer)objectArray[0];
    }

    public void testFibonaci() {
        this.engine.command("ipObjectSpec('InvisibleObject',_T,[" + this.thisID + "],_)," + "assert(ipFibonaci(_T))");
        this.engine.waitUntilIdle();
        Object[] objectArray = this.engine.deterministicGoal("fib(10,X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        Integer n = (Integer)objectArray[0];
        Assert.assertTrue((String)"Got a result", (objectArray != null ? 1 : 0) != 0);
        this.engine.progressMessage("result: " + objectArray[0]);
        Assert.assertEquals((String)"First result", (Object)n, (Object)new Integer(89));
    }

    public int factorial(int n) {
        Object[] objectArray = this.engine.deterministicGoal("fac(" + n + ",X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        return (Integer)objectArray[0];
    }

    public void testFactorial() {
        this.engine.command("ipObjectSpec('InvisibleObject',_T,[" + this.thisID + "],_)," + "assert(ipFactorial(_T))");
        this.engine.waitUntilIdle();
        Object[] objectArray = this.engine.deterministicGoal("fac(7,X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        Integer n = (Integer)objectArray[0];
        Assert.assertTrue((String)"Got a result", (objectArray != null ? 1 : 0) != 0);
        this.engine.progressMessage("result: " + objectArray[0]);
        Assert.assertEquals((String)"First result", (Object)n, (Object)new Integer(5040));
    }

    public TermModel[] someTerms() {
        return new TermModel[]{new TermModel("a"), new TermModel("b")};
    }

    public void testGetRealJavaObject() {
        String string = "javaMessage(" + this.thisID + ",Tref,someTerms), ";
        string = String.valueOf(string) + "ipPrologEngine(E), javaMessage(E,Obj,getRealJavaObject(Tref)), recoverTermModelArray(Obj,[a,b])";
        Assert.assertTrue((boolean)this.engine.deterministicGoal(string));
    }

    public void testStrangeChar() {
        Assert.assertEquals((Object)new String(new char[]{'\u0080'}), (Object)this.engine.deterministicGoal("name(CircleR,[128])", "[string(CircleR)]")[0]);
        Assert.assertTrue((String)new String(new char[]{'\u00e7'}), (this.engine.deterministicGoal("name(CircleR,[231])", "[string(CircleR)]") != null ? 1 : 0) != 0);
    }

    public void testBlockdataSerialization1() {
        Object[] objectArray = new Object[]{new Container()};
        Object[] objectArray2 = this.engine.deterministicGoal("true", "[W]", objectArray, "[W]");
        Container container = (Container)objectArray2[0];
    }

    public void testBlockdataSerialization2() {
        Object[] objectArray = new Object[]{new JFrame("My window")};
        Object[] objectArray2 = this.engine.deterministicGoal("true", "[W]", objectArray, "[]");
        Assert.assertTrue((objectArray2 != null ? 1 : 0) != 0);
    }

    public void kickThread1() {
        this.secondThreadArrived = true;
    }

    public void testJavaThreads() throws InterruptedException {
        this.engine.setThreadedCallbacks(false);
        JavaThread1 javaThread1 = new JavaThread1();
        javaThread1.start();
        Thread.sleep(50L);
        Assert.assertTrue((String)"Got result for thread 2 (reusing)", (boolean)this.engine.deterministicGoal("S=hello, javaMessage(" + this.engine.registerJavaObject((Object)this) + ",kickThread1)", "[string(S)]")[0].equals("hello"));
        javaThread1.join();
        Assert.assertTrue((String)"firstThreadWoke(reusing)", (boolean)this.firstThreadWoke);
        this.firstThreadWoke = false;
        this.secondThreadArrived = false;
        this.engine.setThreadedCallbacks(true);
        JavaThread1 javaThread12 = new JavaThread1();
        javaThread12.start();
        Thread.sleep(50L);
        Assert.assertTrue((String)"Got result for thread 2", (boolean)this.engine.deterministicGoal("S=hello, javaMessage(" + this.engine.registerJavaObject((Object)this) + ",kickThread1)", "[string(S)]")[0].equals("hello"));
        javaThread12.join();
        Assert.assertTrue((String)"firstThreadWoke", (boolean)this.firstThreadWoke);
        Thread[] threadArray = new Thread[3];
        int n = 0;
        while (n < threadArray.length) {
            threadArray[n] = new JavaThreadN();
            threadArray[n].start();
            ++n;
        }
        int n2 = 0;
        while (n2 < threadArray.length) {
            System.out.println("Waiting for end of thread " + n2);
            threadArray[n2].join();
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    extends Thread {
        public void run() {
            try {
                System.out.println("Calling Prolog endless loop");
                PrologEngineTest.this.engine.deterministicGoal("repeat,fail");
                Assert.fail((String)"should have thrown IPInterruptedException");
            }
            catch (IPException iPException) {
                if (iPException instanceof IPInterruptedException) {
                    PrologEngineTest.this.didInterrupt = true;
                }
                System.out.println("didInterrupt==" + PrologEngineTest.this.didInterrupt + " exception class==" + iPException.getClass() + " Got exception:" + iPException);
            }
        }

        /* synthetic */ 1() {
        }
    }

    public static class NumberTypes
    implements Serializable {
        byte b;
        short s;
        int i;
        float f;

        public NumberTypes(byte by, short s, int n, float f) {
            this.b = by;
            this.s = s;
            this.i = n;
            this.f = f;
        }

        public static ObjectExamplePair example() {
            return new ObjectExamplePair(new NumberTypes(-128, Short.MIN_VALUE, -134217728, -3.14159f), (Object)new NumberTypes(127, Short.MAX_VALUE, 0x7FFFFFF, 181.25f));
        }

        public String toString() {
            return "b==" + this.b + ",s==" + this.s + ",i==" + this.i + ",f==" + this.f;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NumberTypes)) {
                return false;
            }
            NumberTypes numberTypes = (NumberTypes)object;
            return numberTypes.b == this.b && numberTypes.s == this.s && numberTypes.i == this.i && numberTypes.f == this.f;
        }
    }

    public static class MyClass
    implements Serializable {
        int one = 0;
        int two = 0;
    }

    public static class Loop
    implements Serializable {
        Loop next;
    }

    class JavaThread1
    extends Thread {
        public void run() {
            boolean bl;
            PrologEngineTest.this.firstThreadWoke = bl = PrologEngineTest.this.engine.deterministicGoal("javaMessage(" + PrologEngineTest.this.engine.registerJavaObject(this) + ",hang)");
        }

        public void hang() throws InterruptedException {
            while (!PrologEngineTest.this.secondThreadArrived) {
                Thread.sleep(1L);
            }
        }

        JavaThread1() {
        }
    }

    class JavaThreadN
    extends Thread {
        public void run() {
            Assert.assertTrue((String)"...", (boolean)PrologEngineTest.this.engine.deterministicGoal("ipObjectSpec(long,X,[long(0,0,0," + Math.round(Math.random() * 10.0) + ")],_), javaMessage('java.lang.Thread',sleep(X))"));
        }

        JavaThreadN() {
        }
    }
}

